package com.ejie.ab59.dao.pagos;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.model.pagos.PagoSan;
import com.ejie.ab59.model.sanciones.Sanciones;

@Repository
@Transactional
public class PagoSanDaoImpl implements PagoSanDao {

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<PagoSan> rwMapFind = new RowMapper<PagoSan>() {
		@Override
		public PagoSan mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			PagoSan pagoSan = new PagoSan();
			pagoSan.setIdPagoSan((resultSet.getObject("IDPAGOSAN") != null ? resultSet.getInt("IDPAGOSAN") : null));
			pagoSan.setFechaViaEjecutiva(resultSet.getDate("FECHAVIAEJE"));
			pagoSan.setPagoFinalizado(
					(resultSet.getObject("PAGOFINALIZADO") != null ? resultSet.getInt("PAGOFINALIZADO") : null));
			pagoSan.setPagoVoluntario(
					(resultSet.getObject("PAGOVOLUNTARIO") != null ? resultSet.getInt("PAGOVOLUNTARIO") : null));
			pagoSan.setReconocimientoVoluntario(
					(resultSet.getObject("RECOVOLUNTARIO") != null ? resultSet.getInt("RECOVOLUNTARIO") : null));
			pagoSan.setTipoPago((resultSet.getObject("TIPOPAGO") != null ? resultSet.getInt("TIPOPAGO") : null));

			pagoSan.setObservacionesCastellano(resultSet.getString("OBSERVACIONESCAS"));
			pagoSan.setObservacionesEuskera(resultSet.getString("OBSERVACIONESEUS"));
			pagoSan.setEnvioCartaPago(
					(resultSet.getObject("ENVIARCARTAPAGO") != null ? resultSet.getInt("ENVIARCARTAPAGO") : null));

			Sanciones sancionAux = new Sanciones();
			sancionAux.setIdSancion((resultSet.getObject("IDSANCION") != null ? resultSet.getInt("IDSANCION") : null));
			sancionAux.setImporteSancion(
					(resultSet.getObject("IMPORTESANCION") != null ? resultSet.getBigDecimal("IMPORTESANCION") : null));
			sancionAux.setImporteResolucion((resultSet.getObject("IMPORTERESOLUCION") != null
					? resultSet.getBigDecimal("IMPORTERESOLUCION") : null));
			sancionAux.setFechaSancionFirme(
					(resultSet.getObject("FECHASANCIONFIRME") != null ? resultSet.getDate("FECHASANCIONFIRME") : null));
			pagoSan.setSancion(sancionAux);

			return pagoSan;
		}
	};

	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	@Override
	public PagoSan add(PagoSan pagoSan) {

		StringBuilder query = new StringBuilder();

		query.append("INSERT INTO PAGO_SAN (ID_PAGO_SAN, ID_SANCION, OBSERVACIONES_CASTELLANO, OBSERVACIONES_EUSKERA , "
				+ " TIPO_PAGO, "
				+ " RECONOCIMIENTO_VOLUNTARIO, PAGO_VOLUNTARIO, PAGO_FINALIZADO, FECHA_VIA_EJE, FECHA_REGISTRO, USUARIO_REGISTRO) "
				+ " VALUES (?,?,?,?,?,?,?,?,?,SYSDATE,?)");

		pagoSan.setIdPagoSan(
				this.jdbcTemplate.queryForObject("SELECT AB59.S_AB5903T00.NEXTVAL FROM DUAL", Integer.class));

		this.jdbcTemplate.update(query.toString(), pagoSan.getIdPagoSan(),
				(pagoSan.getSancion() != null && pagoSan.getSancion().getIdSancion() != null
						? pagoSan.getSancion().getIdSancion() : null),
				pagoSan.getObservacionesCastellano(), pagoSan.getObservacionesEuskera(), pagoSan.getTipoPago(),
				pagoSan.getReconocimientoVoluntario(), pagoSan.getPagoVoluntario(), pagoSan.getPagoFinalizado(),
				pagoSan.getFechaViaEjecutiva(), pagoSan.getUsuarioRegistro());

		return pagoSan;
	}

	@Override
	public PagoSan update(PagoSan pagoSan) {

		StringBuilder query = new StringBuilder();

		query.append("UPDATE PAGO_SAN SET OBSERVACIONES_CASTELLANO = ?, OBSERVACIONES_EUSKERA = ?, TIPO_PAGO=?, "
				+ " RECONOCIMIENTO_VOLUNTARIO=?, PAGO_VOLUNTARIO=?, PAGO_FINALIZADO=?, FECHA_VIA_EJE=?, FECHA_ULTMODIFICACION=SYSDATE, USUARIO_ULTMODIFICACION = ? "
				+ " WHERE ID_PAGO_SAN = ?");

		this.jdbcTemplate.update(query.toString(), pagoSan.getObservacionesCastellano(),
				pagoSan.getObservacionesEuskera(), pagoSan.getTipoPago(), pagoSan.getReconocimientoVoluntario(),
				pagoSan.getPagoVoluntario(), pagoSan.getPagoFinalizado(), pagoSan.getFechaViaEjecutiva(),
				pagoSan.getUsuarioUltModificacion(), pagoSan.getIdPagoSan());

		return pagoSan;
	}

	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * La asignacion de la IDSancion se la hacemos a la tabla de Sancion ya que
	 * aunque el pago no exista, deberemos obtener la informacion de la sancion
	 */
	@Override
	@Transactional(readOnly = true)
	public PagoSan find(PagoSan pagoSan) {
		StringBuilder query = new StringBuilder();

		query.append(
				"SELECT t5903.ID_PAGO_SAN IDPAGOSAN, t5903.OBSERVACIONES_CASTELLANO OBSERVACIONESCAS, t5903.OBSERVACIONES_EUSKERA OBSERVACIONESEUS,"
						+ " t5903.TIPO_PAGO TIPOPAGO,"
						+ " t5903.RECONOCIMIENTO_VOLUNTARIO RECOVOLUNTARIO, t5903.PAGO_VOLUNTARIO PAGOVOLUNTARIO, t5903.PAGO_FINALIZADO PAGOFINALIZADO, t5903.FECHA_VIA_EJE FECHAVIAEJE, "
						+ " t5901.ID_SANCION IDSANCION, t5901.IMPORTE_SANCION IMPORTESANCION, t5901.IMPORTE_RESOLUCION IMPORTERESOLUCION, t5901.FECHA_SANCION_FIRME FECHASANCIONFIRME, "
						+ " t6193.ENVIAR_CARTA_PAGO ENVIARCARTAPAGO "
						+ " FROM PAGO_SAN t5903, SANCIONES t5901, SITUACION_EXPEDIENTE t6193 WHERE 1 = 1 "
						+ " AND t5901.ID_SANCION = t5903.ID_SANCION(+) "
						+ " AND t5901.ID_EXPEDIENTE = t6193.ID_EXPEDIENTE(+) AND t5901.ID_SANCION = ?");

		List<PagoSan> pagoSanList = this.jdbcTemplate.query(query.toString(), this.rwMapFind,
				pagoSan.getSancion().getIdSancion());
		return DataAccessUtils.uniqueResult(pagoSanList);
	}
}
