package com.ejie.ab59.dao.pagos;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.model.expedientes.Expedientes;
import com.ejie.ab59.model.pagos.Liquidaciones;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableRequestDto;

/**
 * LiquidacionesDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class LiquidacionesDaoImpl implements LiquidacionesDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDLIQUIDACIONPAGO", "IDEXPEDIENTE",
			"REFERENCIAPAGO", "IMPORTE", "CODIGOPAGO", "FECHAPAGO", "ESTADO", "TIPOPAGO", "IDTIPOLIQUIDACION",
			"FECHAENVIO", "FOLDERNUMBER" };

	private JdbcTemplate jdbcTemplate;

	private RowMapper<Liquidaciones> rwMap = new RowMapper<Liquidaciones>() {
		@Override
		public Liquidaciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Liquidaciones retorno = new Liquidaciones();
			retorno.setIdLiquidacionPago(
					(resultSet.getObject("IDLIQUIDACIONPAGO") != null ? resultSet.getInt("IDLIQUIDACIONPAGO") : null));
			retorno.setCodigoPago(resultSet.getString("CODIGOPAGO"));
			retorno.setEstado((resultSet.getObject("ESTADO") != null ? resultSet.getInt("ESTADO") : null));
			retorno.setFechaEnvio((resultSet.getObject("FECHAENVIO") != null ? resultSet.getDate("FECHAENVIO") : null));
			retorno.setFechaPago((resultSet.getObject("FECHAPAGO") != null ? resultSet.getDate("FECHAPAGO") : null));
			retorno.setImporte((resultSet.getObject("IMPORTE") != null ? resultSet.getBigDecimal("IMPORTE") : null));
			retorno.setReferenciaPago(resultSet.getString("REFERENCIAPAGO"));
			retorno.setTipoPago((resultSet.getObject("TIPOPAGO") != null ? resultSet.getInt("TIPOPAGO") : null));
			retorno.setIdTipoLiquidacion(
					(resultSet.getObject("IDTIPOLIQUIDACION") != null ? resultSet.getInt("IDTIPOLIQUIDACION") : null));

			Expedientes expediente = null;
			if (resultSet.getObject("IDEXPEDIENTE") != null) {

				expediente = new Expedientes();
				expediente.setIdExpediente(resultSet.getInt("IDEXPEDIENTE"));
				expediente.setFolderNumber(resultSet.getString("FOLDERNUMBER"));
			}
			retorno.setExpediente(expediente);

			return retorno;
		}
	};

	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	@Override
	public Liquidaciones add(Liquidaciones liquidaciones) {

		liquidaciones.setIdLiquidacionPago(
				this.jdbcTemplate.queryForObject("SELECT AB61.S_AB6188T00.NEXTVAL FROM DUAL", Integer.class));

		String query = "INSERT INTO LIQUIDACIONES (ID_LIQUIDACION_PAGO, ID_EXPEDIENTE, REFERENCIA_PAGO, IMPORTE, CODIGO_PAGO, "
				+ " FECHA_PAGO, FECHA_REGISTRO, USUARIO_REGISTRO, ESTADO, TIPO_PAGO, ID_TIPO_LIQUIDACION, FECHA_ENVIO) VALUES (?,?,?,?,?,?,SYSDATE,?,?,?,?,?)";
		this.jdbcTemplate.update(query, liquidaciones.getIdLiquidacionPago(),
				(liquidaciones.getExpediente() != null ? liquidaciones.getExpediente().getIdExpediente() : null),
				liquidaciones.getReferenciaPago(), liquidaciones.getImporte(), liquidaciones.getCodigoPago(),
				liquidaciones.getFechaPago(), liquidaciones.getUsuarioRegistro(), liquidaciones.getEstado(),
				liquidaciones.getTipoPago(), liquidaciones.getIdTipoLiquidacion(), liquidaciones.getFechaEnvio());
		return liquidaciones;
	}

	@Override
	public Liquidaciones update(Liquidaciones liquidaciones) {
		String query = "UPDATE LIQUIDACIONES SET ID_EXPEDIENTE=?, REFERENCIA_PAGO=?, IMPORTE=?, CODIGO_PAGO=?, FECHA_PAGO=?, "
				+ " FECHA_ULTMODIFICACION=SYSDATE, USUARIO_ULTMODIFICACION=?, ESTADO=?, TIPO_PAGO=?, ID_TIPO_LIQUIDACION=?, FECHA_ENVIO=? WHERE ID_LIQUIDACION_PAGO=?";
		this.jdbcTemplate.update(query,
				(liquidaciones.getExpediente() != null ? liquidaciones.getExpediente().getIdExpediente() : null),
				liquidaciones.getReferenciaPago(), liquidaciones.getImporte(), liquidaciones.getCodigoPago(),
				liquidaciones.getFechaPago(), liquidaciones.getUsuarioUltmodificacion(), liquidaciones.getEstado(),
				liquidaciones.getTipoPago(), liquidaciones.getIdTipoLiquidacion(), liquidaciones.getFechaEnvio(),
				liquidaciones.getIdLiquidacionPago());
		return liquidaciones;
	}

	@Override
	@Transactional(readOnly = true)
	public Liquidaciones find(Liquidaciones liquidaciones) {
		String query = "SELECT t6188.ID_LIQUIDACION_PAGO IDLIQUIDACIONPAGO, t6188.ID_EXPEDIENTE IDEXPEDIENTE, t6188.REFERENCIA_PAGO REFERENCIAPAGO, "
				+ " t6188.IMPORTE IMPORTE, t6188.CODIGO_PAGO CODIGOPAGO, t6188.FECHA_PAGO FECHAPAGO, "
				+ " t6188.ESTADO ESTADO, t6188.TIPO_PAGO TIPOPAGO, t6188.ID_TIPO_LIQUIDACION IDTIPOLIQUIDACION, t6188.FECHA_ENVIO FECHAENVIO, t6102.FOLDER_NUMBER FOLDERNUMBER FROM LIQUIDACIONES t6188, EXPEDIENTES t6102 WHERE t6188.ID_EXPEDIENTE = t6102.ID_EXPEDIENTE AND t6188.ID_LIQUIDACION_PAGO = ?  ";

		List<Liquidaciones> liquidacionesList = this.jdbcTemplate.query(query, this.rwMap,
				liquidaciones.getIdLiquidacionPago());
		return DataAccessUtils.uniqueResult(liquidacionesList);
	}

	@Override
	public void remove(Liquidaciones liquidaciones) {
		String query = "DELETE FROM LIQUIDACIONES WHERE ID_LIQUIDACION_PAGO=?";
		this.jdbcTemplate.update(query, liquidaciones.getIdLiquidacionPago());
	}

	@Override
	@Transactional(readOnly = true)
	public List<Liquidaciones> findAll(Liquidaciones liquidaciones, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT t6188.ID_LIQUIDACION_PAGO IDLIQUIDACIONPAGO, t6188.ID_EXPEDIENTE IDEXPEDIENTE, t6188.REFERENCIA_PAGO REFERENCIAPAGO, "
						+ " t6188.IMPORTE IMPORTE, t6188.CODIGO_PAGO CODIGOPAGO, t6188.FECHA_PAGO FECHAPAGO, "
						+ " t6188.ESTADO ESTADO, t6188.TIPO_PAGO TIPOPAGO, t6188.ID_TIPO_LIQUIDACION IDTIPOLIQUIDACION, t6188.FECHA_ENVIO FECHAENVIO, t6102.FOLDER_NUMBER FOLDERNUMBER ");

		query.append("FROM LIQUIDACIONES t6188, EXPEDIENTES t6102 ");

		Map<String, ?> mapaWhere = this.getWhereMap(liquidaciones);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t6188.ID_EXPEDIENTE = t6102.ID_EXPEDIENTE ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query, LiquidacionesDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	@Override
	@Transactional(readOnly = true)
	public List<Liquidaciones> findAllLike(Liquidaciones liquidaciones, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT t6188.ID_LIQUIDACION_PAGO IDLIQUIDACIONPAGO, t6188.ID_EXPEDIENTE IDEXPEDIENTE, t6188.REFERENCIA_PAGO REFERENCIAPAGO, "
						+ " t6188.IMPORTE IMPORTE, t6188.CODIGO_PAGO CODIGOPAGO, t6188.FECHA_PAGO FECHAPAGO, "
						+ " t6188.ESTADO ESTADO, t6188.TIPO_PAGO TIPOPAGO, t6188.ID_TIPO_LIQUIDACION IDTIPOLIQUIDACION, t6188.FECHA_ENVIO FECHAENVIO, t6102.FOLDER_NUMBER FOLDERNUMBER ");

		query.append("FROM LIQUIDACIONES t6188, EXPEDIENTES t6102 ");

		Map<String, ?> mapaWhere = this.getWhereLikeMap(liquidaciones, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t6188.ID_EXPEDIENTE = t6102.ID_EXPEDIENTE ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query, LiquidacionesDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	@Override
	@Transactional(readOnly = true)
	public Long findAllCount(Liquidaciones liquidaciones) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM LIQUIDACIONES t6188 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(liquidaciones);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	@Override
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Liquidaciones liquidaciones, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM LIQUIDACIONES t6188 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(liquidaciones, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	private Map<String, ?> getWhereMap(Liquidaciones liquidaciones) {

		StringBuilder where = new StringBuilder(LiquidacionesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (liquidaciones != null && liquidaciones.getIdLiquidacionPago() != null) {
			where.append(" AND t6188.ID_LIQUIDACION_PAGO = ?");
			params.add(liquidaciones.getIdLiquidacionPago());
		}
		if (liquidaciones != null && liquidaciones.getExpediente() != null
				&& liquidaciones.getExpediente().getIdExpediente() != null) {
			where.append(" AND t6188.ID_EXPEDIENTE = ?");
			params.add(liquidaciones.getExpediente().getIdExpediente());
		}
		if (liquidaciones != null && liquidaciones.getReferenciaPago() != null) {
			where.append(" AND t6188.REFERENCIA_PAGO = ?");
			params.add(liquidaciones.getReferenciaPago());
		}
		if (liquidaciones != null && liquidaciones.getImporte() != null) {
			where.append(" AND t6188.IMPORTE = ?");
			params.add(liquidaciones.getImporte());
		}
		if (liquidaciones != null && liquidaciones.getCodigoPago() != null) {
			where.append(" AND t6188.CODIGO_PAGO = ?");
			params.add(liquidaciones.getCodigoPago());
		}
		if (liquidaciones != null && liquidaciones.getFechaPago() != null) {
			where.append(" AND t6188.FECHA_PAGO = ?");
			params.add(liquidaciones.getFechaPago());
		}
		if (liquidaciones != null && liquidaciones.getEstado() != null) {
			where.append(" AND t6188.ESTADO = ?");
			params.add(liquidaciones.getEstado());
		}
		if (liquidaciones != null && liquidaciones.getTipoPago() != null) {
			where.append(" AND t6188.TIPO_PAGO = ?");
			params.add(liquidaciones.getTipoPago());
		}
		if (liquidaciones != null && liquidaciones.getIdTipoLiquidacion() != null) {
			where.append(" AND t6188.ID_TIPO_LIQUIDACION = ?");
			params.add(liquidaciones.getIdTipoLiquidacion());
		}
		if (liquidaciones != null && liquidaciones.getFechaEnvio() != null) {
			where.append(" AND t6188.FECHA_ENVIO = ?");
			params.add(liquidaciones.getFechaEnvio());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	private Map<String, Object> getWhereLikeMap(Liquidaciones liquidaciones, Boolean startsWith) {

		StringBuilder where = new StringBuilder(LiquidacionesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (liquidaciones != null && liquidaciones.getIdLiquidacionPago() != null) {
			where.append(" AND t6188.ID_LIQUIDACION_PAGO = ?");
			params.add(liquidaciones.getIdLiquidacionPago());
		}
		if (liquidaciones != null && liquidaciones.getExpediente() != null
				&& liquidaciones.getExpediente().getIdExpediente() != null) {
			where.append(" AND t6188.ID_EXPEDIENTE = ?");
			params.add(liquidaciones.getExpediente().getIdExpediente());
		}
		if (liquidaciones != null && liquidaciones.getReferenciaPago() != null) {
			where.append(" AND UPPER(t6188.REFERENCIA_PAGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(liquidaciones.getReferenciaPago().toUpperCase() + "%");
			} else {
				params.add("%" + liquidaciones.getReferenciaPago().toUpperCase() + "%");
			}
			where.append(" AND t6188.REFERENCIA_PAGO IS NOT NULL");
		}
		if (liquidaciones != null && liquidaciones.getImporte() != null) {
			where.append(" AND t6188.IMPORTE = ?");
			params.add(liquidaciones.getImporte());
		}
		if (liquidaciones != null && liquidaciones.getCodigoPago() != null) {
			where.append(" AND UPPER(t6188.CODIGO_PAGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(liquidaciones.getCodigoPago().toUpperCase() + "%");
			} else {
				params.add("%" + liquidaciones.getCodigoPago().toUpperCase() + "%");
			}
			where.append(" AND t6188.CODIGO_PAGO IS NOT NULL");
		}
		if (liquidaciones != null && liquidaciones.getFechaPago() != null) {
			where.append(" AND t6188.FECHA_PAGO = ?");
			params.add(liquidaciones.getFechaPago());
		}
		if (liquidaciones != null && liquidaciones.getEstado() != null) {
			where.append(" AND t6188.ESTADO = ?");
			params.add(liquidaciones.getEstado());
		}
		if (liquidaciones != null && liquidaciones.getTipoPago() != null) {
			where.append(" AND t6188.TIPO_PAGO = ?");
			params.add(liquidaciones.getTipoPago());
		}
		if (liquidaciones != null && liquidaciones.getIdTipoLiquidacion() != null) {
			where.append(" AND t6188.ID_TIPO_LIQUIDACION = ?");
			params.add(liquidaciones.getIdTipoLiquidacion());
		}
		if (liquidaciones != null && liquidaciones.getFechaEnvio() != null) {
			where.append(" AND t6188.FECHA_ENVIO = ?");
			params.add(liquidaciones.getFechaEnvio());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	public static final int STRING_BUILDER_INIT = 4096;
}
