package com.ejie.ab59.dao.nora;

/**
 * Municipio  
 */

import java.util.List;

import com.ejie.ab59.model.nora.T17Municipio;
import com.ejie.x38.dto.Pagination;

/**
 * MunicipioDao  
 * 
 *  
 */
public interface T17MunicipioDao {

	/**
	 * Finds a single row in the Municipio table.
	 * 
	 * @param municipio
	 *            T17Municipio
	 * @return t17Municipio
	 */
	T17Municipio find(T17Municipio municipio);

	/**
	 * Finds a List of rows in the Municipio table.
	 * 
	 * @param municipio
	 *            T17Municipio
	 * @param pagination
	 *            Pagination<Object>
	 * @return List<T17Municipio>
	 */
	List<T17Municipio> findAll(T17Municipio municipio, Pagination<Object> pagination);

	/**
	 * Counts rows in the Municipio table.
	 * 
	 * @param municipio
	 *            t17Municipio
	 * @return Long
	 */
	Long findAllCount(T17Municipio municipio);

	/**
	 * Finds rows in the Municipio table using like.
	 * 
	 * @param municipio
	 *            T17Municipio
	 * @param pagination
	 *            Pagination<Object>
	 * @param startsWith
	 *            Boolean
	 * 
	 * @return List<T17Municipio>
	 */
	List<T17Municipio> findAllLike(T17Municipio municipio, Pagination<Object> pagination, Boolean startsWith);
}
