package com.ejie.ab59.dao.listados;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.model.listados.Listados;
import com.ejie.ab59.model.listados.RelLisPro;

/**
 * 
 *  
 *
 */

@Repository
@Transactional
public class RelLisProDaoImpl implements RelLisProDao {

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<RelLisPro> rwMapCombo = new RowMapper<RelLisPro>() {
		public RelLisPro mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			RelLisPro relLisPro = new RelLisPro();
			relLisPro.setDescripcionCastellano(resultSet.getString("DESCLISTADOCAS"));
			relLisPro.setDescripcionEuskera(resultSet.getString("DESCLISTADOEUS"));

			/* Lsitados */
			Listados listadosAux = new Listados();
			listadosAux.setIdListado(resultSet.getInt("IDLISTADO"));
			relLisPro.setListado(listadosAux);

			return relLisPro;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds a list of rows in the RelLisPro table.
	 *
	 * @param relLisPro
	 *            RelLisPro
	 * 
	 * @return List<RelLisPro>
	 */
	public List<RelLisPro> cargarCombo(RelLisPro relLisPro) {

		StringBuilder query = new StringBuilder();
		List<Object> params = new ArrayList<Object>();

		query.append(
				"SELECT t6108.ID_LISTADO IDLISTADO, t6105.DESCRIPCION_CASTELLANO DESCLISTADOCAS, t6105.DESCRIPCION_EUSKERA DESCLISTADOEUS");
		query.append(" FROM REL_LIS_PRO t6105");
		query.append(" INNER JOIN LISTADOS t6108 ON t6105.ID_LISTADO = t6108.ID_LISTADO");
		query.append(" WHERE 1 = 1");
		if (relLisPro != null && relLisPro.getProcedimiento().getIdProcedimiento() != null) {
			query.append(" AND t6105.ID_PROCEDIMIENTO = ?");
			params.add(relLisPro.getProcedimiento().getIdProcedimiento());
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMapCombo, params.toArray());
	}
}
