package com.ejie.ab59.dao.listados;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.model.listados.Busquedas;
import com.ejie.ab59.model.listados.Parametros;

/**
 * 
 *  
 *
 */

@Repository
@Transactional
public class ParametrosDaoImpl implements ParametrosDao {

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Parametros> rwMap = new RowMapper<Parametros>() {
		public Parametros mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Parametros parametros = new Parametros();
			parametros.setIdParametro(resultSet.getInt("IDPARAMETRO"));
			parametros.setNombre(resultSet.getString("NOMBRE"));
			parametros.setTextoMostrar(resultSet.getString("TEXTOMOSTRARCAS"));
			parametros.setTextoMostrarEus(resultSet.getString("TEXTOMOSTRAREUS"));
			parametros.setTipoParametro(resultSet.getInt("TIPOPARAMETRO"));

			/* Busqueda */
			Busquedas busquedasAux = new Busquedas();
			busquedasAux.setIdBusqueda(resultSet.getInt("IDBUSQUEDA"));
			parametros.setBusqueda(busquedasAux);

			return parametros;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds rows in the Parametros table using like.
	 *
	 * @param parametros
	 *            Parametros
	 * 
	 * @return List<Parametros>
	 */
	public List<Parametros> findByBusqueda(Parametros parametros) {

		StringBuilder query = new StringBuilder();
		List<Object> params = new ArrayList<Object>();

		query.append("SELECT  t6109.ID_PARAMETRO IDPARAMETRO, t6109.ID_BUSQUEDA IDBUSQUEDA");
		query.append(
				", t6109.NOMBRE NOMBRE, t6109.TEXTO_MOSTRAR TEXTOMOSTRARCAS, t6109.TEXTO_MOSTRAR_EUS TEXTOMOSTRAREUS, t6109.TIPO_PARAMETRO TIPOPARAMETRO");
		query.append(" FROM PARAMETROS t6109 ");
		query.append("WHERE t6109.ID_BUSQUEDA = ?");
		params.add(parametros.getBusqueda().getIdBusqueda());

		return this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
}
