package com.ejie.ab59.dao.listados;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.model.listados.Busquedas;
import com.ejie.ab59.model.listados.Listados;

/**
 * 
 *  
 *
 */

@Repository
@Transactional
public class BusquedasDaoImpl implements BusquedasDao {

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Busquedas> rwMap = new RowMapper<Busquedas>() {
		public Busquedas mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Busquedas busqueda = new Busquedas();
			busqueda.setIdBusqueda(resultSet.getInt("IDBUSQUEDA"));
			busqueda.setNombre(resultSet.getString("NOMBRE"));
			busqueda.setSqlListado(resultSet.getString("SQLLISTADO"));
			busqueda.setCampos(resultSet.getString("CAMPOS"));

			/* Lsitados */
			Listados listadosAux = new Listados();
			listadosAux.setIdListado(resultSet.getInt("IDLISTADO"));
			busqueda.setListado(listadosAux);

			return busqueda;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds rows in the Busquedas table using like.
	 *
	 * @param busquedas
	 *            Busquedas
	 * 
	 * @return List<Busquedas>
	 */
	public List<Busquedas> findByListado(Busquedas busquedas) {

		StringBuilder query = new StringBuilder();
		List<Object> params = new ArrayList<Object>();

		query.append("SELECT t6138.ID_BUSQUEDA IDBUSQUEDA, t6138.ID_LISTADO IDLISTADO");
		query.append(", t6138.NOMBRE NOMBRE, t6138.SQL_LISTADO SQLLISTADO, t6138.CAMPOS CAMPOS");
		query.append(" FROM BUSQUEDAS t6138");
		query.append(" WHERE t6138.ID_LISTADO = ?");
		params.add(busquedas.getListado().getIdListado());

		return (List<Busquedas>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
}
