package com.ejie.ab59.dao.expedientes;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.model.expedientes.SubtipoTercero;

/**
 * 
 *  
 *
 */

@Repository
@Transactional
public class SubtipoTerceroDaoImpl implements SubtipoTerceroDao {

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<SubtipoTercero> rwMapCombo = new RowMapper<SubtipoTercero>() {
		public SubtipoTercero mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			SubtipoTercero subtipoTercero = new SubtipoTercero();
			subtipoTercero.setIdSubtipoTercero(resultSet.getInt("IDSUBTIPOTERCERO"));
			subtipoTercero.setDescripcionCastellano(resultSet.getString("DESCRIPCIONCASTELLANO"));
			subtipoTercero.setDescripcionEuskera(resultSet.getString("DESCRIPCIONEUSKERA"));

			return subtipoTercero;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds a list of rows in the SubtipoTercero table.
	 *
	 * @param subtipoTercero
	 *            SubtipoTercero
	 * 
	 * @return List<SubtipoTercero>
	 */
	public List<SubtipoTercero> cargarCombo(SubtipoTercero subtipoTerceroDao) {
		StringBuilder query = new StringBuilder();
		query.append(
				"SELECT  ID_SUBTIPO_TERCERO IDSUBTIPOTERCERO, DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA");
		query.append(" FROM SUBTIPO_TERCERO");

		return this.jdbcTemplate.query(query.toString(), this.rwMapCombo);
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
