package com.ejie.ab59.dao.expedientes;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.model.expedientes.DatosDirecciones;
import com.ejie.ab59.model.expedientes.DatosTerceros;
import com.ejie.ab59.model.expedientes.Expedientes;
import com.ejie.ab59.model.expedientes.RelExpTer;
import com.ejie.ab59.model.expedientes.Sexo;
import com.ejie.ab59.model.expedientes.SubtipoTercero;
import com.ejie.ab59.model.expedientes.TiposDocumento;
import com.ejie.ab59.model.expedientes.TiposTercero;
import com.ejie.ab59.model.nora.T17Localidad;
import com.ejie.ab59.model.nora.T17Municipio;
import com.ejie.ab59.model.nora.T17Pais;
import com.ejie.ab59.model.nora.T17Provincia;
import com.ejie.x38.dto.TableRequestDto;

/**
 * 
 *  
 *
 */

@Repository
@Transactional
public class RelExpTerDaoImpl implements RelExpTerDao {

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */

	private RowMapper<RelExpTer> rwMap = new RowMapper<RelExpTer>() {
		public RelExpTer mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			RelExpTer relExpTer = new RelExpTer();
			relExpTer.setIdRelExpTer(resultSet.getInt("IDRELEXPTER"));
			relExpTer.setParticipantId(resultSet.getString("PARTICIPANTID"));
			relExpTer.setUsuarioRegistro(resultSet.getString("USUARIOREGISTRO"));

			Expedientes expedienteAux = new Expedientes();
			expedienteAux.setIdExpediente(resultSet.getInt("IDEXPEDIENTE"));
			relExpTer.setExpediente(expedienteAux);

			DatosTerceros datosTercerosAux = new DatosTerceros();
			datosTercerosAux.setIdTercero(resultSet.getInt("DTIDTERCERO"));
			datosTercerosAux.setDocumento(resultSet.getString("DTDOCUMENTO"));
			datosTercerosAux.setNombre(resultSet.getString("DTNOMBRE"));
			datosTercerosAux.setApellido1(resultSet.getString("DTAPELLIDO1"));
			datosTercerosAux.setApellido2(resultSet.getString("DTAPELLIDO2"));

			Sexo sexo = new Sexo();
			sexo.setIdSexo(resultSet.getLong("DTIDSEXO"));

			datosTercerosAux.setSexo(sexo);
			datosTercerosAux.setTelefono(resultSet.getLong("DTTELEFONO"));
			datosTercerosAux.setEmail(resultSet.getString("DTEMAIL"));
			datosTercerosAux.setIdioma(resultSet.getInt("DTIDIOMA"));
			datosTercerosAux.setTipoParticipante(resultSet.getInt("DTTIPOPARTICIPANTE"));

			TiposDocumento tipoDocumentoAux = new TiposDocumento();
			tipoDocumentoAux.setIdTipoDocumento(resultSet.getInt("DTIDTIPODOCUMENTO"));
			datosTercerosAux.setTipoDocumento(tipoDocumentoAux);

			relExpTer.setDatosTercero(datosTercerosAux);

			TiposTercero tiposTerceroAux = new TiposTercero();
			tiposTerceroAux.setIdTipoTercero(resultSet.getInt("IDTIPOTERCERO"));
			relExpTer.setTipoTercero(tiposTerceroAux);

			return relExpTer;
		}
	};

	private RowMapper<RelExpTer> rwMapIdExpediente = new RowMapper<RelExpTer>() {
		public RelExpTer mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			RelExpTer relExpTer = new RelExpTer();
			DatosTerceros datosTercero = new DatosTerceros();
			relExpTer.setIdRelExpTer(resultSet.getInt("ID_REL_EXP_TER"));
			datosTercero.setIdTercero(resultSet.getInt("IDTERCERO"));
			relExpTer.setDatosTercero(datosTercero);
			relExpTer.setParticipantId(resultSet.getString("PARTICIPANTID"));

			return relExpTer;
		}
	};

	private RowMapper<RelExpTer> rwMapParticipantes = new RowMapper<RelExpTer>() {
		public RelExpTer mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			RelExpTer relExpTer = new RelExpTer();
			DatosTerceros datosTerceroAux = new DatosTerceros();
			TiposTercero tiposTerceroAux = new TiposTercero();
			tiposTerceroAux.setIdTipoTercero(resultSet.getInt("IDTIPOTERCERO"));
			tiposTerceroAux.setDescripcionCastellano(resultSet.getString("DESCRIPCIONCASTELLANO"));
			tiposTerceroAux.setDescripcionEuskera(resultSet.getString("DESCRIPCIONEUSKERA"));

			DatosDirecciones datosDirecciones = new DatosDirecciones();
			datosDirecciones.setIdDireccion(resultSet.getInt("IDDIRECCION"));
			if (resultSet.wasNull()) {
				datosDirecciones.setIdDireccion(null);
			}
			datosDirecciones.setDireccion(resultSet.getString("DIRECCION"));
			datosDirecciones.setCodigoPostal(resultSet.getString("CODIGOPOSTAL"));
			datosDirecciones.setNumero(resultSet.getString("NUMERO"));
			datosDirecciones.setEscalera(resultSet.getString("ESCALERA"));
			datosDirecciones.setPiso(resultSet.getString("PISO"));
			datosDirecciones.setLetra(resultSet.getString("LETRA"));
			datosDirecciones.setDescripcionCiudad(resultSet.getString("DESCRIPCIONCIUDAD"));
			datosDirecciones.setDescripcionProvincia(resultSet.getString("DESCRIPCIONPROVINCIA"));

			T17Pais pais = new T17Pais();
			pais.setId(resultSet.getString("IDPAIS"));
			T17Provincia provincia = new T17Provincia();
			provincia.setId(resultSet.getString("IDPROVINCIA"));
			T17Municipio municipio = new T17Municipio();
			municipio.setId(resultSet.getString("IDMUNICIPIO"));
			T17Localidad localidad = new T17Localidad();
			localidad.setId(resultSet.getString("IDLOCALIDAD"));

			datosDirecciones.setPais(pais);
			datosDirecciones.setProvincia(provincia);
			datosDirecciones.setMunicipio(municipio);
			datosDirecciones.setLocalidad(localidad);

			datosTerceroAux.setIdTercero(resultSet.getInt("DATOSTERCEROSIDTERCERO"));
			datosTerceroAux.setNombre(resultSet.getString("NOMBRE"));
			datosTerceroAux.setApellido1(resultSet.getString("APELLIDO1"));
			datosTerceroAux.setApellido2(resultSet.getString("APELLIDO2"));
			datosTerceroAux.setDocumento(resultSet.getString("DOCUMENTO"));
			datosTerceroAux.setTipoParticipante(resultSet.getInt("DATOSTERCEROSTIPOPARTICIPANTE"));
			datosTerceroAux.setDatosDirecciones(datosDirecciones);
			relExpTer.setDatosTercero(datosTerceroAux);
			relExpTer.setTipoTercero(tiposTerceroAux);
			relExpTer.setParticipantId(resultSet.getString("PARTICIPANTID"));
			relExpTer.setOrden(resultSet.getInt("ORDEN"));
			relExpTer.setIdRelExpTer(resultSet.getInt("IDRELEXPTER"));

			SubtipoTercero subtipoTerceroAux = new SubtipoTercero();
			subtipoTerceroAux.setIdSubtipoTercero(resultSet.getInt("IDSUBTIPOTERCERO"));
			if (resultSet.wasNull()) {
				subtipoTerceroAux.setIdSubtipoTercero(null);
			}
			subtipoTerceroAux.setDescripcionCastellano(resultSet.getString("DESCSUBTIPOCAS"));
			subtipoTerceroAux.setDescripcionEuskera(resultSet.getString("DESCSUBTIPOEUS"));
			relExpTer.setSubtipoTercero(subtipoTerceroAux);

			return relExpTer;
		}
	};

	private RowMapper<RelExpTer> rwMapAllByExpediente = new RowMapper<RelExpTer>() {
		public RelExpTer mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			RelExpTer relExpTer = new RelExpTer();
			relExpTer.setIdRelExpTer(resultSet.getInt("IDRELEXPTER"));

			DatosTerceros datosTercerosAux = new DatosTerceros();
			datosTercerosAux.setDocumento(resultSet.getString("DOCUMENTO"));
			datosTercerosAux.setNombre(resultSet.getString("NOMBRE"));
			datosTercerosAux.setApellido1(resultSet.getString("APELLIDO1"));
			datosTercerosAux.setApellido2(resultSet.getString("APELLIDO2"));

			relExpTer.setDatosTercero(datosTercerosAux);

			TiposTercero tiposTerceroAux = new TiposTercero();
			tiposTerceroAux.setDescripcionCastellano(resultSet.getString("DESCTIPOTERCEROCAS"));
			tiposTerceroAux.setDescripcionEuskera(resultSet.getString("DESCTIPOTERCEROEUS"));
			relExpTer.setTipoTercero(tiposTerceroAux);

			return relExpTer;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds a single row in the RelExpTer table.
	 *
	 * @param relexpter
	 *            RelExpTer
	 * @return RelExpTer
	 */
	@Transactional(readOnly = true)
	public RelExpTer find(RelExpTer relexpter) {
		StringBuilder query = new StringBuilder();

		query.append("SELECT t6134.ID_REL_EXP_TER IDRELEXPTER, t6134.ID_EXPEDIENTE IDEXPEDIENTE");
		query.append(", t6134.ID_TIPO_TERCERO IDTIPOTERCERO, t6134.PARTICIPANT_ID PARTICIPANTID");
		query.append(", t6134.FECHA_REGISTRO FECHAREGISTRO, t6134.USUARIO_REGISTRO USUARIOREGISTRO");
		query.append(", t6135.ID_TERCERO DTIDTERCERO");
		query.append(", t6135.DOCUMENTO DTDOCUMENTO, t6135.ID_TIPO_DOCUMENTO DTIDTIPODOCUMENTO");
		query.append(", t6135.NOMBRE DTNOMBRE, t6135.APELLIDO1 DTAPELLIDO1, t6135.APELLIDO2 DTAPELLIDO2");
		query.append(", t6135.ID_SEXO DTIDSEXO, t6135.TELEFONO DTTELEFONO, t6135.EMAIL DTEMAIL, t6135.IDIOMA DTIDIOMA");
		query.append(", t6135.TIPO_PARTICIPANTE DTTIPOPARTICIPANTE, t6135.FECHA_REGISTRO DTFECHAREGISTRO");
		query.append(", t6135.ID_REPRESENTANTE DTIDREPRESENTANTE");
		query.append(" FROM REL_EXP_TER t6134");
		query.append(" INNER JOIN DATOS_TERCEROS t6135 ON t6134.ID_TERCERO = t6135.ID_TERCERO");
		query.append(" WHERE t6134.ID_REL_EXP_TER = ?");

		List<RelExpTer> relexpterList = this.jdbcTemplate.query(query.toString(), this.rwMap,
				relexpter.getIdRelExpTer());
		return DataAccessUtils.uniqueResult(relexpterList);
	}

	/**
	 * Remove a single row in the RelExpTer table.
	 *
	 * @param relexpter
	 *            RelExpTer
	 * @return
	 */
	public void remove(Integer idRelExpTer) {

		String query = "DELETE FROM REL_EXP_TER WHERE ID_REL_EXP_TER = ?";

		this.jdbcTemplate.update(query, idRelExpTer);
	}

	/**
	 * Remove a single row in the RelExpTer dado un idTercero
	 *
	 * @param relexpter
	 *            RelExpTer
	 * @return
	 */
	public void removeidTercero(Integer idTercero) {

		String query = "DELETE FROM REL_EXP_TER WHERE ID_TERCERO = ?";

		this.jdbcTemplate.update(query, idTercero);
	}

	@Override
	public RelExpTer update(RelExpTer relExpTerPlatea) {
		String query = "UPDATE REL_EXP_TER SET ID_TIPO_TERCERO = ?, FECHA_ULTMODIFICACION = sysdate, USUARIO_ULTMODIFICACION = ? WHERE ID_REL_EXP_TER = ?";

		Object getTiposTerceroIdTipoTerceroAux = null;
		if (relExpTerPlatea.getTipoTercero() != null && relExpTerPlatea.getTipoTercero().getIdTipoTercero() != null) {
			getTiposTerceroIdTipoTerceroAux = relExpTerPlatea.getTipoTercero().getIdTipoTercero();
		}

		this.jdbcTemplate.update(query, getTiposTerceroIdTipoTerceroAux, relExpTerPlatea.getUsuarioUltmodificacion(),
				relExpTerPlatea.getIdRelExpTer());

		return relExpTerPlatea;
	}

	/**
	 * Finds lista de parcicipaciones de la tabla RelExpTer
	 *
	 * @param relexpter
	 *            RelExpTer
	 * @return RelExpTer
	 */
	@Transactional(readOnly = true)
	public List<RelExpTer> findByIdExpediente(Integer idExpediente) {

		StringBuilder query = new StringBuilder();

		query.append(
				"SELECT t6134.ID_REL_EXP_TER AS ID_REL_EXP_TER, t6134.PARTICIPANT_ID AS PARTICIPANTID, t6134.ID_TERCERO AS IDTERCERO");
		query.append(" FROM REL_EXP_TER t6134");
		query.append(" WHERE t6134.ID_EXPEDIENTE = ? AND (ID_TIPO_TERCERO = 1 OR ID_TIPO_TERCERO = 3)");

		List<RelExpTer> relexpterList = this.jdbcTemplate.query(query.toString(), this.rwMapIdExpediente, idExpediente);

		return relexpterList;
	}

	/**
	 * Finds lista de participantes de la tabla RelExpTer
	 *
	 * @param idExpediente
	 *            Integer
	 * 
	 * @return List<RelExpTe>
	 */
	@Transactional(readOnly = true)
	public List<RelExpTer> findParticipantes(Integer idExpediente) {

		StringBuilder query = new StringBuilder();

		query.append("SELECT t6134.ID_TIPO_TERCERO AS IDTIPOTERCERO");
		query.append(
				", t6106.DESCRIPCION_CASTELLANO AS DESCRIPCIONCASTELLANO, t6106.DESCRIPCION_EUSKERA AS DESCRIPCIONEUSKERA");
		query.append(", t6134.PARTICIPANT_ID AS PARTICIPANTID, t6134.ID_TERCERO AS DATOSTERCEROSIDTERCERO");
		query.append(", t6135.NOMBRE AS NOMBRE, t6135.APELLIDO1 AS APELLIDO1, t6135.APELLIDO2 AS APELLIDO2");
		query.append(", t6135.TIPO_PARTICIPANTE AS DATOSTERCEROSTIPOPARTICIPANTE, t6135.DOCUMENTO AS DOCUMENTO");
		// Tipo de Tercero:
		// 1: Solicitante
		// 3: Afectado
		// 6: Representante Legal
		// 2: Persona de Contacto
		// 7: Denunciado Provisional
		query.append(", DECODE (t6134.ID_TIPO_TERCERO, 1, 1, 2, 4, 3, 2, 6, 3, 7, 5) AS ORDEN");
		query.append(", t6134.ID_REL_EXP_TER IDRELEXPTER, t6134.ID_SUBTIPO_TERCERO IDSUBTIPOTERCERO");
		query.append(", t6130.DESCRIPCION_CASTELLANO DESCSUBTIPOCAS, t6130.DESCRIPCION_EUSKERA DESCSUBTIPOEUS");
		query.append(", t6136.ID_DIRECCION IDDIRECCION, t6136.ID_PAIS IDPAIS, t6136.ID_PROVINCIA IDPROVINCIA");
		query.append(", t6136.ID_MUNICIPIO IDMUNICIPIO, t6136.ID_LOCALIDAD IDLOCALIDAD, t6136.DIRECCION DIRECCION");
		query.append(
				", t6136.NUMERO NUMERO, t6136.ESCALERA ESCALERA, t6136.PISO PISO, t6136.LETRA LETRA, t6136.CODIGO_POSTAL CODIGOPOSTAL");
		query.append(", t6136.DESCRIPCION_CIUDAD DESCRIPCIONCIUDAD, t6136.DESCRIPCION_PROVINCIA DESCRIPCIONPROVINCIA");
		query.append(" FROM REL_EXP_TER t6134");
		query.append(" INNER JOIN DATOS_TERCEROS t6135 ON t6134.ID_TERCERO = t6135.ID_TERCERO");
		query.append(" INNER JOIN TIPOS_TERCERO t6106 ON t6134.ID_TIPO_TERCERO = t6106.ID_TIPO_TERCERO");
		query.append(" LEFT OUTER JOIN SUBTIPO_TERCERO t6130 ON t6134.ID_SUBTIPO_TERCERO = t6130.ID_SUBTIPO_TERCERO");
		query.append(
				" LEFT OUTER JOIN DATOS_DIRECCIONES t6136 ON t6135.ID_TERCERO = t6136.ID_TERCERO AND t6136.ID_TIPO_DIRECCION = "
						+ Constantes.DIRECCION_CANAL_POSTAL);
		query.append(" WHERE t6134.ID_EXPEDIENTE = ?");
		query.append(" ORDER BY ORDEN, PARTICIPANTID, DATOSTERCEROSTIPOPARTICIPANTE ASC");

		List<RelExpTer> relexpterList = this.jdbcTemplate.query(query.toString(), this.rwMapParticipantes,
				idExpediente);

		return relexpterList;
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Update tipo de una relacion
	 *
	 * @param relexpter
	 *            RelExpTer
	 * @return RelExpTer
	 */
	public RelExpTer updateSubtipo(RelExpTer relexpter) {

		String query = "UPDATE REL_EXP_TER SET ID_SUBTIPO_TERCERO = ?,	FECHA_ULTMODIFICACION = SYSDATE, USUARIO_ULTMODIFICACION = ? WHERE	PARTICIPANT_ID = ?";

		Object getSubtipoTerceroAux = null;
		if (relexpter.getSubtipoTercero() != null && relexpter.getSubtipoTercero().getIdSubtipoTercero() != null) {
			getSubtipoTerceroAux = relexpter.getSubtipoTercero().getIdSubtipoTercero();
		}

		this.jdbcTemplate.update(query, getSubtipoTerceroAux, relexpter.getUsuarioUltmodificacion(),
				relexpter.getParticipantId());

		return relexpter;
	}

	/**
	 * Finds a list of rows in the RelExpTer table.
	 *
	 * @param relExpTer
	 *            RelExpTer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<RelExpTer>
	 */
	@Transactional(readOnly = true)
	public List<RelExpTer> findAllByExpediente(RelExpTer relExpTer, TableRequestDto tableRequestDto) {

		StringBuilder query = new StringBuilder();
		List<Object> params = new ArrayList<Object>();

		query.append("SELECT t6134.ID_REL_EXP_TER IDRELEXPTER");
		query.append(", t6106.DESCRIPCION_CASTELLANO DESCTIPOTERCEROCAS, t6106.DESCRIPCION_EUSKERA DESCTIPOTERCEROEUS");
		query.append(", t6135.DOCUMENTO");
		query.append(", t6135.NOMBRE, t6135.APELLIDO1, t6135.APELLIDO2");
		query.append(" FROM REL_EXP_TER t6134");
		query.append(" INNER JOIN DATOS_TERCEROS t6135 ON t6134.ID_TERCERO = t6135.ID_TERCERO");
		query.append(" AND t6135.TIPO_PARTICIPANTE = 0");
		query.append(" INNER JOIN TIPOS_TERCERO t6106 ON t6134.ID_TIPO_TERCERO = t6106.ID_TIPO_TERCERO");
		query.append(" WHERE t6134.ID_EXPEDIENTE = ?");
		params.add(relExpTer.getExpediente().getIdExpediente());

		return this.jdbcTemplate.query(query.toString(), this.rwMapAllByExpediente, params.toArray());
	}

	/**
	 * Counts rows in the RelExpTer table.
	 *
	 * @param relExpTer
	 *            RelExpTer
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllByExpedienteCount(RelExpTer relExpTer) {

		List<Object> params = new ArrayList<Object>();

		StringBuilder query = new StringBuilder("SELECT COUNT(1)");
		query.append(" FROM REL_EXP_TER t6134");
		query.append(" INNER JOIN DATOS_TERCEROS t6135 ON t6134.ID_TERCERO = t6135.ID_TERCERO");
		query.append(" AND t6135.TIPO_PARTICIPANTE = 0");
		query.append(" INNER JOIN TIPOS_TERCERO t6106 ON t6134.ID_TIPO_TERCERO = t6106.ID_TIPO_TERCERO");
		query.append(" WHERE t6134.ID_EXPEDIENTE = ?");
		params.add(relExpTer.getExpediente().getIdExpediente());

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	@Override
	public List<RelExpTer> findAllSinExpediente(RelExpTer relExpTer, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder();
		List<Object> params = new ArrayList<Object>();

		query.append("SELECT '' IDRELEXPTER");
		query.append(", '" + Constantes.AFECTADO_CAS + "' DESCTIPOTERCEROCAS, '" + Constantes.AFECTADO_EUS
				+ "' DESCTIPOTERCEROEUS");
		query.append(", t6135.DOCUMENTO");
		query.append(", t6135.NOMBRE, t6135.APELLIDO1, t6135.APELLIDO2");
		query.append(" FROM DATOS_TERCEROS t6135");
		query.append(" WHERE t6135.ID_TERCERO = ?");
		query.append(" AND t6135.TIPO_PARTICIPANTE = 0");
		params.add(relExpTer.getDatosTercero().getIdTercero());

		return this.jdbcTemplate.query(query.toString(), this.rwMapAllByExpediente, params.toArray());
	}

	@Override
	public Long findAllSinExpedienteCount(RelExpTer relExpTer) {
		List<Object> params = new ArrayList<Object>();

		StringBuilder query = new StringBuilder("SELECT COUNT(1)");
		query.append(" FROM DATOS_TERCEROS t6135");
		query.append(" WHERE t6135.ID_TERCERO = ?");
		query.append(" AND t6135.TIPO_PARTICIPANTE = 0");
		params.add(relExpTer.getDatosTercero().getIdTercero());

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}
}
