package com.ejie.ab59.dao.expedientes;

import java.util.List;

import com.ejie.ab59.model.expedientes.RelExpTer;
import com.ejie.x38.dto.TableRequestDto;

/**
 * 
 *  
 *
 */

public interface RelExpTerDao {

	/**
	 * Finds a single row in the RelExpTer table.
	 *
	 * @param relexpter
	 *            RelExpTer
	 * @return RelExpTer
	 */
	RelExpTer find(RelExpTer relexpter);

	/**
	 * Remove a single row in the RelExpTer table.
	 *
	 * @param relexpter
	 *            RelExpTer
	 * @return
	 */
	void remove(Integer idRelExpTer);

	/**
	 * Remove a single row in the RelExpTer dado un idTercero
	 *
	 * @param relexpter
	 *            RelExpTer
	 * @return
	 */
	void removeidTercero(Integer idTercero);

	/**
	 * Finds lista de parcicipaciones de la tabla RelExpTer
	 *
	 * @param relexpter
	 *            RelExpTer
	 * @return RelExpTer
	 */
	List<RelExpTer> findByIdExpediente(Integer idExpediente);

	/**
	 * Finds lista de participantes de la tabla RelExpTer
	 *
	 * @param idExpediente
	 *            Integer
	 * 
	 * @return List<RelExpTe>
	 */
	List<RelExpTer> findParticipantes(Integer idExpediente);

	/**
	 * Update tipo de una relacion
	 *
	 * @param relexpter
	 *            RelExpTer
	 * @return RelExpTer
	 */
	RelExpTer updateSubtipo(RelExpTer relexpter);

	/**
	 * Finds a list of rows in the RelExpTer table.
	 *
	 * @param relExpTer
	 *            RelExpTer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<RelExpTer>
	 */
	List<RelExpTer> findAllByExpediente(RelExpTer relExpTer, TableRequestDto tableRequestDto);

	/**
	 * Counts rows in the RelExpTer table.
	 *
	 * @param relExpTer
	 *            RelExpTer
	 * @return Long
	 */
	Long findAllByExpedienteCount(RelExpTer relExpTer);

	List<RelExpTer> findAllSinExpediente(RelExpTer filterRelExpTer, TableRequestDto tableRequestDto);

	Long findAllSinExpedienteCount(RelExpTer relExpTer);

	RelExpTer update(RelExpTer relExpTerPlatea);
}
