package com.ejie.ab59.dao.expedientes;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.model.expedientes.DatosDirecciones;
import com.ejie.ab59.model.expedientes.RelExpDir;
import com.ejie.ab59.model.nora.T17Localidad;
import com.ejie.ab59.model.nora.T17Municipio;
import com.ejie.ab59.model.nora.T17Provincia;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableRequestDto;

/**
 * RelExpDirDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class RelExpDirDaoImpl implements RelExpDirDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDRELEXPDIR", "IDEXPEDIENTE", "IDDIRECCION",
			"FECHAREGISTRO", "USUARIOREGISTRO" };

	private JdbcTemplate jdbcTemplate;

	private RowMapper<RelExpDir> rwMapAll = new RowMapper<RelExpDir>() {
		public RelExpDir mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			RelExpDir relExpDir = new RelExpDir();
			relExpDir.setIdRelExpDir(resultSet.getInt("IDRELEXPDIR"));
			relExpDir.setIdDireccion(resultSet.getInt("IDDIRECCION"));
			relExpDir.setIdExpediente(resultSet.getInt("IDEXPEDIENTE"));
			DatosDirecciones datosDireccionAux = new DatosDirecciones();
			datosDireccionAux.setIdDireccion(resultSet.getInt("IDDIRECCION"));
			datosDireccionAux.setEstablecimiento(resultSet.getString("ESTABLECIMIENTO"));
			datosDireccionAux.setIdentificadorEstablecimiento(resultSet.getString("IDENTIFICADORESTABLECIMIENTO"));
			T17Provincia t17Provincia = new T17Provincia();
			t17Provincia.setId(resultSet.getString("IDPROVINCIA"));
			datosDireccionAux.setProvincia(t17Provincia);
			T17Municipio municipioAux = new T17Municipio();
			municipioAux.setId(resultSet.getString("IDMUNICIPIO"));
			datosDireccionAux.setMunicipio(municipioAux);
			T17Localidad localidadAux = new T17Localidad();
			localidadAux.setId(resultSet.getString("IDLOCALIDAD"));
			datosDireccionAux.setLocalidad(localidadAux);
			datosDireccionAux.setDireccion(resultSet.getString("DIRECCION"));
			datosDireccionAux.setNumero(resultSet.getString("NUMERO"));
			datosDireccionAux.setEscalera(resultSet.getString("ESCALERA"));
			datosDireccionAux.setPiso(resultSet.getString("PISO"));
			datosDireccionAux.setLetra(resultSet.getString("LETRA"));
			datosDireccionAux.setCodigoPostal(resultSet.getString("CODIGOPOSTAL"));
			datosDireccionAux.setDescripcionProvincia(resultSet.getString("DESCPROVINCIA"));
			datosDireccionAux.setDescripcionMunicipio(resultSet.getString("DESCMUNICIPIO"));
			datosDireccionAux.setDescripcionLocalidad(resultSet.getString("DESCLOCALIDAD"));
			relExpDir.setDatosDirecciones(datosDireccionAux);

			return relExpDir;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the RelExpDir table.
	 *
	 * @param relexpdir
	 *            RelExpDir
	 * @return RelExpDir
	 */
	public RelExpDir add(RelExpDir relexpdir) {

		int idRelExpDir = this.jdbcTemplate.queryForObject("SELECT AB61.S_AB6151T00.NEXTVAL FROM DUAL", Integer.class);
		relexpdir.setIdRelExpDir(idRelExpDir);

		String query = "INSERT INTO REL_EXP_DIR (ID_REL_EXP_DIR, ID_EXPEDIENTE, ID_DIRECCION, FECHA_REGISTRO, USUARIO_REGISTRO) VALUES (?,?,?,SYSDATE,?)";
		this.jdbcTemplate.update(query, relexpdir.getIdRelExpDir(), relexpdir.getIdExpediente(),
				relexpdir.getIdDireccion(), relexpdir.getUsuarioRegistro());
		return relexpdir;
	}

	/**
	 * Removes a single row in the RelExpDir table.
	 *
	 * @param relExpDir
	 *            RelExpDir
	 * @return
	 */
	public void remove(RelExpDir relExpDir) {
		String query = "DELETE FROM REL_EXP_DIR WHERE ID_REL_EXP_DIR = ?";
		this.jdbcTemplate.update(query, relExpDir.getIdRelExpDir());
	}

	/**
	 * Finds a list of rows in the PropuestasSancion table.
	 *
	 * @param relExpDir
	 *            RelExpDir
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<RelExpDir>
	 */
	@Transactional(readOnly = true)
	public List<RelExpDir> findAll(RelExpDir relExpDir, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder();

		query.append(
				"SELECT t6151.ID_REL_EXP_DIR IDRELEXPDIR, t6151.ID_EXPEDIENTE IDEXPEDIENTE, t6136.ESTABLECIMIENTO ESTABLECIMIENTO,  t6136.IDENTIFICADOR_ESTABLECIMIENTO IDENTIFICADORESTABLECIMIENTO,");
		query.append(
				" t6136.ID_DIRECCION IDDIRECCION,  t6136.ID_PROVINCIA IDPROVINCIA,  prov.DS_O DESCPROVINCIA,  t6136.ID_MUNICIPIO IDMUNICIPIO,");
		query.append(
				" mun.DS_O DESCMUNICIPIO, t6136.ID_LOCALIDAD IDLOCALIDAD, loc.DS_O DESCLOCALIDAD, t6136.DIRECCION DIRECCION, t6136.NUMERO NUMERO,");
		query.append(
				" t6136.ESCALERA ESCALERA, t6136.PISO PISO, t6136.LETRA LETRA, t6136.CODIGO_POSTAL CODIGOPOSTAL FROM DATOS_DIRECCIONES t6136");
		query.append(
				" INNER JOIN REL_EXP_DIR t6151 ON T6136.ID_DIRECCION = t6151.ID_DIRECCION LEFT OUTER JOIN PROVINCIAS prov ON t6136.ID_PROVINCIA = prov.ID");
		query.append(
				" LEFT OUTER JOIN MUNICIPIOS mun ON t6136.ID_MUNICIPIO  = mun.ID AND t6136.ID_PROVINCIA = mun.PROVINCIA_ID LEFT OUTER JOIN LOCALIDADES loc");
		query.append(
				" ON t6136.ID_LOCALIDAD  = loc.ID AND t6136.ID_PROVINCIA = loc.PROVINCIA_ID AND t6136.ID_MUNICIPIO = loc.MUNICIPIO_ID");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(relExpDir);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query);
		}

		return (List<RelExpDir>) this.jdbcTemplate.query(query.toString(), this.rwMapAll, params.toArray());

	}

	/**
	 * Counts rows in the RelExpTer table.
	 *
	 * @param relExpDir
	 *            RelExpDir
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(RelExpDir relExpDir) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM DATOS_DIRECCIONES t6136 INNER JOIN REL_EXP_DIR t6151 ON T6136.ID_DIRECCION = t6151.ID_DIRECCION");
		query.append(
				" LEFT OUTER JOIN PROVINCIAS prov ON t6136.ID_PROVINCIA = prov.ID LEFT OUTER JOIN MUNICIPIOS mun ON t6136.ID_MUNICIPIO  = mun.ID ");
		query.append(
				" AND t6136.ID_PROVINCIA = mun.PROVINCIA_ID LEFT OUTER JOIN LOCALIDADES loc ON t6136.ID_LOCALIDAD  = loc.ID");
		query.append(" AND t6136.ID_PROVINCIA = loc.PROVINCIA_ID AND t6136.ID_MUNICIPIO = loc.MUNICIPIO_ID ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(relExpDir);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the PropuestasSancion entity
	 *
	 * @param propuestassancion
	 *            RelExpDir Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(RelExpDir relExpDir) {

		StringBuilder where = new StringBuilder(RelExpDirDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		/* Nº Expediente Origen */
		if (relExpDir != null && relExpDir.getIdExpediente() != null) {
			where.append(" AND t6151.ID_EXPEDIENTE   = ? ");
			params.add(relExpDir.getIdExpediente());
		}

		if (relExpDir != null && relExpDir.getDatosDirecciones() != null
				&& relExpDir.getDatosDirecciones().getTipoDireccion().getIdTipoDireccion() != null) {
			where.append(" AND t6136.ID_TIPO_DIRECCION = ? ");

		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
