package com.ejie.ab59.dao.expedientes;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.model.expedientes.Expedientes;
import com.ejie.ab59.model.procedimientos.Aplicaciones;
import com.ejie.ab59.model.procedimientos.Procedimientos;

/**
 * ExpedientesDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ExpedientesDaoImpl implements ExpedientesDao {

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */

	private RowMapper<Expedientes> rwMapIdExpediente = new RowMapper<Expedientes>() {
		public Expedientes mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Expedientes expedientes = new Expedientes();
			expedientes.setIdExpediente(resultSet.getInt("IDEXPEDIENTE"));

			return expedientes;
		}
	};

	private RowMapper<Expedientes> rwMapExpediente = new RowMapper<Expedientes>() {
		public Expedientes mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Expedientes expedientes = new Expedientes();
			expedientes.setIdExpediente(resultSet.getInt("IDEXPEDIENTE"));
			expedientes.setFolderId(resultSet.getString("FOLDERID"));

			Procedimientos procedimientoAux = new Procedimientos();
			procedimientoAux.setCodProcedureId(resultSet.getString("PROCEDUREID"));
			expedientes.setProcedimiento(procedimientoAux);

			return expedientes;
		}
	};

	private RowMapper<Expedientes> rwMapUrlApli = new RowMapper<Expedientes>() {
		public Expedientes mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Expedientes expediente = new Expedientes();

			Procedimientos procedimiento = new Procedimientos();

			Aplicaciones aplicacion = new Aplicaciones();

			aplicacion.setUrlAplicacion(resultSet.getString("URL_APLICACION"));

			procedimiento.setAplicacion(aplicacion);

			expediente.setProcedimiento(procedimiento);

			expediente.setFolderId(resultSet.getString("FOLDER_ID"));

			return expediente;

		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * busco datos de expediente segun su Folder_id
	 *
	 * @param expedientes
	 *            Expedientes
	 * @return Expedientes
	 */
	@Transactional(readOnly = true)
	public Expedientes findIdExpediente(Expedientes expedientes) {
		String query = "SELECT ID_EXPEDIENTE IDEXPEDIENTE FROM EXPEDIENTES t1 WHERE FOLDER_ID= ?";

		List<Expedientes> expedientesList = this.jdbcTemplate.query(query, this.rwMapIdExpediente,
				expedientes.getFolderId());
		return DataAccessUtils.uniqueResult(expedientesList);
	}

	/**
	 * busco el expediente asociado a la sanción
	 *
	 * @param idSancion
	 *            Integer
	 * 
	 * @return Expedientes
	 */
	@Transactional(readOnly = true)
	public Expedientes findExpedienteSancion(Integer idSancion) {

		StringBuilder query = new StringBuilder();

		query.append("SELECT t01.ID_EXPEDIENTE IDEXPEDIENTE, t6102.FOLDER_ID FOLDERID");
		query.append(", t6101.COD_PROCEDURE_ID PROCEDUREID");
		query.append(" FROM EXPEDIENTES t6102");
		query.append(" INNER JOIN SANCIONES t01 ON t6102.ID_EXPEDIENTE = t01.ID_EXPEDIENTE");
		query.append(" INNER JOIN PROCEDIMIENTOS t6101 ON t6102.ID_PROCEDIMIENTO = t6101.ID_PROCEDIMIENTO");
		query.append(" WHERE t01.ID_SANCION = ?");

		List<Expedientes> expedientesList = this.jdbcTemplate.query(query.toString(), this.rwMapExpediente, idSancion);
		return DataAccessUtils.uniqueResult(expedientesList);
	}

	public Expedientes findUrlFromFolderNumber(String FolderId) {

		String query = "SELECT T1.URL_APLICACION, T2.FOLDER_ID FROM APLICACIONES T1 JOIN PROCEDIMIENTOS T3 ON T1.ID_APLICACION = T3.ID_APLICACION JOIN EXPEDIENTES T2 ON T2.ID_PROCEDIMIENTO = T3.ID_PROCEDIMIENTO WHERE T2.FOLDER_NUMBER = ?";

		List<Expedientes> propuestasSancionList = this.jdbcTemplate.query(query, this.rwMapUrlApli, FolderId);

		if (!propuestasSancionList.isEmpty()) {
			return propuestasSancionList.get(0);
		} else {
			return null;
		}

	}

	@Override
	public boolean findExpedienteCerrado(Expedientes expediente) {
		String query = "SELECT COUNT(1) FROM REL_EXP_FECH t6142, FECHAS_EXPEDIENTE t6144 WHERE t6142.ID_FECHA_EXPEDIENTE = t6144.ID_FECHA_EXPEDIENTE AND t6144.ETIQUETA_FECHA = ? AND t6142.ID_EXPEDIENTE = ?";

		List<Object> params = new ArrayList<Object>();
		params.add(Constantes.FECHA_CIERRE);
		params.add(expediente.getIdExpediente());

		Long expedientesCount = this.jdbcTemplate.queryForObject(query, params.toArray(), Long.class);

		if (expedientesCount > 0) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
