package com.ejie.ab59.dao.expedientes;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.model.expedientes.DatosTerceros;

/**
 * 
 *  
 *
 */

@Repository
@Transactional
public class DatosTercerosDaoImpl implements DatosTercerosDao {

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<DatosTerceros> rwMapDocumento = new RowMapper<DatosTerceros>() {
		public DatosTerceros mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			DatosTerceros datosTercero = new DatosTerceros();
			datosTercero.setIdTercero(resultSet.getInt("IDTERCERO"));
			datosTercero.setDocumento(resultSet.getString("DOCUMENTO"));

			return datosTercero;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Remove a single row in the DATOS_TERCEROS dado un idTercero
	 *
	 * @param relexpter
	 *            RelExpTer
	 * @return
	 */
	public void remove(Integer idTercero) {

		String query = "DELETE FROM DATOS_TERCEROS WHERE ID_TERCERO = ?";

		this.jdbcTemplate.update(query, idTercero);
	}

	@Override
	public List<DatosTerceros> findDocumentosPartesInculpadas(Integer idExpediente) {
		StringBuilder query = new StringBuilder();
		query.append(
				"SELECT t1.ID_TERCERO IDTERCERO, t1.DOCUMENTO DOCUMENTO FROM DATOS_TERCEROS t1, REL_EXP_TER t2, EXPEDIENTES t3 WHERE t1.ID_TERCERO = t2.ID_TERCERO AND t2.ID_EXPEDIENTE = t3.ID_EXPEDIENTE AND t2.ID_SUBTIPO_TERCERO = ? AND t3.ID_EXPEDIENTE = ?");

		return this.jdbcTemplate.query(query.toString(), this.rwMapDocumento, Constantes.PARTE_INCULPADA, idExpediente);
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
