package com.ejie.ab59.dao.expedientes;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.model.expedientes.DatosDirecciones;
import com.ejie.ab59.model.expedientes.DatosTerceros;
import com.ejie.ab59.model.nora.T17Localidad;
import com.ejie.ab59.model.nora.T17Municipio;
import com.ejie.ab59.model.nora.T17Provincia;

/**
 * 
 *  
 *
 */

@Repository
@Transactional
public class DatosDireccionesDaoImpl implements DatosDireccionesDao {

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<DatosDirecciones> rwMapDireccion = new RowMapper<DatosDirecciones>() {
		@Override
		public DatosDirecciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			DatosDirecciones datosDireccion = new DatosDirecciones();

			datosDireccion.setIdDireccion(resultSet.getInt("IDDIRECCION"));
			datosDireccion.setDireccion(resultSet.getString("DIRECCION"));
			datosDireccion.setNumero(resultSet.getString("NUMERO"));
			datosDireccion.setEscalera(resultSet.getString("ESCALERA"));
			datosDireccion.setPiso(resultSet.getString("PISO"));
			datosDireccion.setLetra(resultSet.getString("LETRA"));
			datosDireccion.setCodigoPostal(resultSet.getString("CODIGOPOSTAL"));
			datosDireccion.setEstablecimiento(resultSet.getString("ESTABLECIMIENTO"));
			datosDireccion.setIdentificadorEstablecimiento(resultSet.getString("IDENTIFICADORESTABLECIMIENTO"));

			T17Provincia provinciaAux = new T17Provincia();
			provinciaAux.setId(resultSet.getString("IDPROVINCIA"));
			provinciaAux.setDsO(resultSet.getString("DESCPROVINCIA"));
			datosDireccion.setProvincia(provinciaAux);

			T17Municipio municipioAux = new T17Municipio();
			municipioAux.setProvinciaId(resultSet.getString("IDPROVINCIA"));
			municipioAux.setId(resultSet.getString("IDMUNICIPIO"));
			municipioAux.setDsO(resultSet.getString("DESCMUNICIPIO"));
			datosDireccion.setMunicipio(municipioAux);

			T17Localidad localidadAux = new T17Localidad();
			localidadAux.setProvinciaId(resultSet.getString("IDPROVINCIA"));
			localidadAux.setMunicipioId(resultSet.getString("IDMUNICIPIO"));
			localidadAux.setId(resultSet.getString("IDLOCALIDAD"));
			localidadAux.setDsO(resultSet.getString("DESCLOCALIDAD"));
			datosDireccion.setLocalidad(localidadAux);

			return datosDireccion;
		}
	};

	private RowMapper<DatosDirecciones> rwMapBuscarEstablecimiento = new RowMapper<DatosDirecciones>() {
		@Override
		public DatosDirecciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			DatosDirecciones datosDireccion = new DatosDirecciones();

			datosDireccion.setIdDireccion(resultSet.getInt("IDDIRECCION"));
			datosDireccion.setDireccion(resultSet.getString("DIRECCION"));
			datosDireccion.setNumero(resultSet.getString("NUMERO"));
			datosDireccion.setEscalera(resultSet.getString("ESCALERA"));
			datosDireccion.setPiso(resultSet.getString("PISO"));
			datosDireccion.setLetra(resultSet.getString("LETRA"));
			datosDireccion.setCodigoPostal(resultSet.getString("CODIGOPOSTAL"));
			datosDireccion.setEstablecimiento(resultSet.getString("ESTABLECIMIENTO"));
			datosDireccion.setIdentificadorEstablecimiento(resultSet.getString("IDENTIFICADORESTABLECIMIENTO"));

			T17Provincia provinciaAux = new T17Provincia();
			provinciaAux.setId(resultSet.getString("IDPROVINCIA"));
			if (resultSet.wasNull()) {
				provinciaAux.setId(null);
			}
			datosDireccion.setProvincia(provinciaAux);

			T17Municipio municipioAux = new T17Municipio();
			municipioAux.setId(resultSet.getString("IDMUNICIPIO"));
			if (resultSet.wasNull()) {
				municipioAux.setId(null);
			}
			datosDireccion.setMunicipio(municipioAux);

			T17Localidad localidadAux = new T17Localidad();
			localidadAux.setId(resultSet.getString("IDLOCALIDAD"));
			if (resultSet.wasNull()) {
				localidadAux.setId(null);
			}
			datosDireccion.setLocalidad(localidadAux);

			return datosDireccion;
		}
	};

	private RowMapper<DatosDirecciones> rwMapPK = new RowMapper<DatosDirecciones>() {
		@Override
		public DatosDirecciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new DatosDirecciones(resultSet.getInt("IDDIRECCION"));
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Borrar la dirección de una sanción
	 *
	 * @param idTercero
	 *            Integer
	 * @return
	 */
	@Override
	public void removeDireccionesTerceroPostal(Integer idTercero) {

		String query = "DELETE FROM DATOS_DIRECCIONES WHERE ID_TERCERO = ? AND ID_TIPO_DIRECCION = "
				+ Constantes.DIRECCION_CANAL_POSTAL;

		this.jdbcTemplate.update(query, idTercero);
	}

	/**
	 * Inserts a single row in the DatosDirecciones table.
	 *
	 * @param datosDirecciones
	 *            DatosDirecciones
	 * @return DatosDirecciones
	 */
	@Override
	public DatosDirecciones add(DatosDirecciones datosDirecciones) {

		StringBuilder query = new StringBuilder();

		query.append(
				"INSERT INTO DATOS_DIRECCIONES (ID_DIRECCION, ID_TIPO_DIRECCION, DIRECCION, NUMERO, ESCALERA, PISO, LETRA, CODIGO_POSTAL");
		query.append(
				", ID_PROVINCIA, ID_MUNICIPIO, ID_LOCALIDAD, ESTABLECIMIENTO, IDENTIFICADOR_ESTABLECIMIENTO, DESCRIPCION_CIUDAD, DESCRIPCION_PROVINCIA");
		query.append(", ID_PAIS, FECHA_REGISTRO, USUARIO_REGISTRO) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,SYSDATE,?)");

		datosDirecciones.setIdDireccion(
				this.jdbcTemplate.queryForObject("SELECT AB61.S_AB6136T00.NEXTVAL FROM DUAL", Integer.class));

		Object getProvincia = null;
		if (datosDirecciones.getProvincia() != null && datosDirecciones.getProvincia().getId() != null) {
			getProvincia = datosDirecciones.getProvincia().getId();
		}
		Object getMunicipio = null;
		if (datosDirecciones.getMunicipio() != null && datosDirecciones.getMunicipio().getId() != null) {
			getMunicipio = datosDirecciones.getMunicipio().getId();
		}
		Object getLocalidad = null;
		if (datosDirecciones.getLocalidad() != null && datosDirecciones.getLocalidad().getId() != null) {
			getLocalidad = datosDirecciones.getLocalidad().getId();
		}
		Object getPais = null;
		if (datosDirecciones.getPais() != null && datosDirecciones.getPais().getId() != null) {
			getPais = datosDirecciones.getPais().getId();
		}

		this.jdbcTemplate.update(query.toString(), datosDirecciones.getIdDireccion(),
				datosDirecciones.getTipoDireccion().getIdTipoDireccion(), datosDirecciones.getDireccion(),
				datosDirecciones.getNumero(), datosDirecciones.getEscalera(), datosDirecciones.getPiso(),
				datosDirecciones.getLetra(), datosDirecciones.getCodigoPostal(), getProvincia, getMunicipio,
				getLocalidad, datosDirecciones.getEstablecimiento(), datosDirecciones.getIdentificadorEstablecimiento(),
				datosDirecciones.getDescripcionCiudad(), datosDirecciones.getDescripcionProvincia(), getPais,
				datosDirecciones.getUsuarioRegistro());

		return datosDirecciones;
	}

	@Override
	public DatosDirecciones update(DatosDirecciones datosDirecciones) {
		StringBuilder query = new StringBuilder();

		query.append(
				"UPDATE DATOS_DIRECCIONES SET  DIRECCION = ?, NUMERO = ?, ESCALERA = ?, PISO = ?, LETRA = ?, CODIGO_POSTAL = ?");
		query.append(
				", ID_PROVINCIA = ?, ID_MUNICIPIO = ?, ID_LOCALIDAD = ?, ESTABLECIMIENTO = ?, IDENTIFICADOR_ESTABLECIMIENTO = ?");
		query.append(", FECHA_ULTMODIFICACION = SYSDATE, USUARIO_ULTMODIFICACION = ? WHERE ID_DIRECCION = ? ");

		Object getProvincia = null;
		if (datosDirecciones.getProvincia() != null && datosDirecciones.getProvincia().getId() != null) {
			getProvincia = datosDirecciones.getProvincia().getId();
		}
		Object getMunicipio = null;
		if (datosDirecciones.getMunicipio() != null && datosDirecciones.getMunicipio().getId() != null) {
			getMunicipio = datosDirecciones.getMunicipio().getId();
		}
		Object getLocalidad = null;
		if (datosDirecciones.getLocalidad() != null && datosDirecciones.getLocalidad().getId() != null) {
			getLocalidad = datosDirecciones.getLocalidad().getId();
		}
		if (datosDirecciones.getPais() != null && datosDirecciones.getPais().getId() != null) {
			datosDirecciones.getPais().getId();
		}

		this.jdbcTemplate.update(query.toString(), datosDirecciones.getDireccion(), datosDirecciones.getNumero(),
				datosDirecciones.getEscalera(), datosDirecciones.getPiso(), datosDirecciones.getLetra(),
				datosDirecciones.getCodigoPostal(), getProvincia, getMunicipio, getLocalidad,
				datosDirecciones.getEstablecimiento(), datosDirecciones.getIdentificadorEstablecimiento(),
				datosDirecciones.getUsuarioUltmodificacion(), datosDirecciones.getIdDireccion());

		return datosDirecciones;
	}

	/**
	 * Removes a single row in the DatosDirecciones table.
	 *
	 * @param datosDirecciones
	 *            DatosDirecciones
	 * @return
	 */
	@Override
	public void remove(DatosDirecciones datosDirecciones) {
		String query = "DELETE FROM DATOS_DIRECCIONES WHERE ID_DIRECCION= ?";
		this.jdbcTemplate.update(query, datosDirecciones.getIdDireccion());
	}

	/**
	 * Buscar la dirección asociada a la sanción
	 *
	 * @param idSancion
	 *            Integer
	 * 
	 * @return DatosDirecciones
	 */
	@Override
	@Transactional(readOnly = true)
	public DatosDirecciones findDireccion(Integer idSancion) {

		StringBuilder query = new StringBuilder();

		query.append(
				"SELECT t6136.ESTABLECIMIENTO ESTABLECIMIENTO, t6136.IDENTIFICADOR_ESTABLECIMIENTO IDENTIFICADORESTABLECIMIENTO");
		query.append(", t6136.ID_DIRECCION IDDIRECCION, t6136.ID_PROVINCIA IDPROVINCIA, prov.DS_O DESCPROVINCIA");
		query.append(", t6136.ID_MUNICIPIO IDMUNICIPIO, mun.DS_O DESCMUNICIPIO");
		query.append(", t6136.ID_LOCALIDAD IDLOCALIDAD, loc.DS_O DESCLOCALIDAD");
		query.append(", t6136.DIRECCION DIRECCION, t6136.NUMERO NUMERO, t6136.ESCALERA ESCALERA");
		query.append(", t6136.PISO PISO, t6136.LETRA LETRA, t6136.CODIGO_POSTAL CODIGOPOSTAL");
		query.append(" FROM DATOS_DIRECCIONES t6136");
		query.append(" INNER JOIN REL_EXP_DIR t6151 ON T6136.ID_DIRECCION = t6151.ID_DIRECCION");
		query.append(" INNER JOIN SANCIONES t01 ON t6151.ID_EXPEDIENTE = t01.ID_EXPEDIENTE");
		query.append(" LEFT OUTER JOIN PROVINCIAS prov ON t6136.ID_PROVINCIA = prov.ID");
		query.append(
				" LEFT OUTER JOIN MUNICIPIOS mun ON t6136.ID_MUNICIPIO = mun.ID AND t6136.ID_PROVINCIA = mun.PROVINCIA_ID");
		query.append(
				" LEFT OUTER JOIN LOCALIDADES loc ON t6136.ID_LOCALIDAD = loc.ID AND t6136.ID_PROVINCIA = loc.PROVINCIA_ID AND t6136.ID_MUNICIPIO = loc.MUNICIPIO_ID");
		query.append(" WHERE t01.ID_SANCION = ?");

		List<DatosDirecciones> datosDireccionesList = this.jdbcTemplate.query(query.toString(), this.rwMapDireccion,
				idSancion);

		return DataAccessUtils.uniqueResult(datosDireccionesList);
	}

	@Override
	public DatosDirecciones buscarEstablecimiento(String numeroRegistro) {
		StringBuilder query = new StringBuilder();

		query.append(
				"SELECT t1.NOMBRE_COMERCIAL ESTABLECIMIENTO, t6136.IDENTIFICADOR_ESTABLECIMIENTO IDENTIFICADORESTABLECIMIENTO");
		query.append(", t6136.ID_DIRECCION IDDIRECCION, t6136.ID_PROVINCIA IDPROVINCIA");
		query.append(", t6136.ID_MUNICIPIO IDMUNICIPIO, t6136.ID_LOCALIDAD IDLOCALIDAD");
		query.append(", t6136.DIRECCION DIRECCION, t6136.NUMERO NUMERO, t6136.ESCALERA ESCALERA");
		query.append(", t6136.PISO PISO, t6136.LETRA LETRA, t6136.CODIGO_POSTAL CODIGOPOSTAL");
		query.append(" FROM ESTABLECIMIENTOS_REGISTRADOS t1, REL_EST_DIR t2, DATOS_DIRECCIONES t6136");
		query.append(" WHERE t1.ID_ESTABLECIMIENTO = t2.ID_ESTABLECIMIENTO AND t2.ID_DIRECCION = t6136.ID_DIRECCION");
		query.append(" AND t6136.ID_TIPO_DIRECCION = ? AND t1.IDENTIFICADOR_ESTABLECIMIENTO = ?");

		List<DatosDirecciones> datosDireccionesList = this.jdbcTemplate.query(query.toString(),
				this.rwMapBuscarEstablecimiento, Constantes.UBICACION_ACTIVIDAD, numeroRegistro);

		return DataAccessUtils.uniqueResult(datosDireccionesList);
	}

	/**
	 * Buscar la direcciónes asociadas a la sanción
	 *
	 * @param idSancion
	 *            Integer
	 * 
	 * @return List<DatosDirecciones>
	 */

	@Override
	@Transactional(readOnly = true)
	public List<DatosDirecciones> findDireccionesSancion(Integer idSancion) {

		StringBuilder query = new StringBuilder();

		query.append(
				"SELECT t6136.ESTABLECIMIENTO ESTABLECIMIENTO, t6136.IDENTIFICADOR_ESTABLECIMIENTO IDENTIFICADORESTABLECIMIENTO");
		query.append(", t6136.ID_DIRECCION IDDIRECCION, t6136.ID_PROVINCIA IDPROVINCIA, prov.DS_O DESCPROVINCIA");
		query.append(", t6136.ID_MUNICIPIO IDMUNICIPIO, mun.DS_O DESCMUNICIPIO");
		query.append(", t6136.ID_LOCALIDAD IDLOCALIDAD, loc.DS_O DESCLOCALIDAD");
		query.append(", t6136.DIRECCION DIRECCION, t6136.NUMERO NUMERO, t6136.ESCALERA ESCALERA");
		query.append(", t6136.PISO PISO, t6136.LETRA LETRA, t6136.CODIGO_POSTAL CODIGOPOSTAL");
		query.append(" FROM DATOS_DIRECCIONES t6136");
		query.append(" INNER JOIN REL_EXP_DIR t6151 ON T6136.ID_DIRECCION = t6151.ID_DIRECCION");
		query.append(" INNER JOIN SANCIONES t01 ON t6151.ID_EXPEDIENTE = t01.ID_EXPEDIENTE");
		query.append(" LEFT OUTER JOIN PROVINCIAS prov ON t6136.ID_PROVINCIA = prov.ID");
		query.append(
				" LEFT OUTER JOIN MUNICIPIOS mun ON t6136.ID_MUNICIPIO = mun.ID AND t6136.ID_PROVINCIA = mun.PROVINCIA_ID");
		query.append(
				" LEFT OUTER JOIN LOCALIDADES loc ON t6136.ID_LOCALIDAD = loc.ID AND t6136.ID_PROVINCIA = loc.PROVINCIA_ID AND t6136.ID_MUNICIPIO = loc.MUNICIPIO_ID");
		query.append(" WHERE t01.ID_SANCION = ?");

		List<DatosDirecciones> datosDireccionesList = this.jdbcTemplate.query(query.toString(), this.rwMapDireccion,
				idSancion);

		return datosDireccionesList;
	}

	/**
	 * Buscar la direcciónes asociadas a la sanción
	 *
	 * @param idSancion
	 *            Integer
	 * 
	 * @return List<DatosDirecciones>
	 */
	@Override
	@Transactional(readOnly = true)
	public List<DatosDirecciones> findDireccionesSancionEstablecimiento(Integer idSancion,
			String identificadorEstablecimiento) {

		StringBuilder query = new StringBuilder();

		query.append(
				"SELECT t6136.ESTABLECIMIENTO ESTABLECIMIENTO, t6136.IDENTIFICADOR_ESTABLECIMIENTO IDENTIFICADORESTABLECIMIENTO");
		query.append(", t6136.ID_DIRECCION IDDIRECCION, t6136.ID_PROVINCIA IDPROVINCIA, prov.DS_O DESCPROVINCIA");
		query.append(", t6136.ID_MUNICIPIO IDMUNICIPIO, mun.DS_O DESCMUNICIPIO");
		query.append(", t6136.ID_LOCALIDAD IDLOCALIDAD, loc.DS_O DESCLOCALIDAD");
		query.append(", t6136.DIRECCION DIRECCION, t6136.NUMERO NUMERO, t6136.ESCALERA ESCALERA");
		query.append(", t6136.PISO PISO, t6136.LETRA LETRA, t6136.CODIGO_POSTAL CODIGOPOSTAL");
		query.append(" FROM DATOS_DIRECCIONES t6136");
		query.append(" INNER JOIN REL_EXP_DIR t6151 ON T6136.ID_DIRECCION = t6151.ID_DIRECCION");
		query.append(" INNER JOIN SANCIONES t01 ON t6151.ID_EXPEDIENTE = t01.ID_EXPEDIENTE");
		query.append(" LEFT OUTER JOIN PROVINCIAS prov ON t6136.ID_PROVINCIA = prov.ID");
		query.append(
				" LEFT OUTER JOIN MUNICIPIOS mun ON t6136.ID_MUNICIPIO = mun.ID AND t6136.ID_PROVINCIA = mun.PROVINCIA_ID");
		query.append(
				" LEFT OUTER JOIN LOCALIDADES loc ON t6136.ID_LOCALIDAD = loc.ID AND t6136.ID_PROVINCIA = loc.PROVINCIA_ID AND t6136.ID_MUNICIPIO = loc.MUNICIPIO_ID");
		query.append(" WHERE t01.ID_SANCION = ? AND t6136.IDENTIFICADOR_ESTABLECIMIENTO=?");

		List<DatosDirecciones> datosDireccionesList = this.jdbcTemplate.query(query.toString(), this.rwMapDireccion,
				idSancion, identificadorEstablecimiento);

		return datosDireccionesList;
	}

	/**
	 * Updates a single row in the Sanciones table.
	 *
	 * @param datosDireccion
	 *            DatosDirecciones
	 * @return DatosDirecciones
	 */
	@Override
	public DatosDirecciones updateUbicacion(DatosDirecciones datosDireccion) {

		StringBuilder query = new StringBuilder();

		query.append("UPDATE DATOS_DIRECCIONES SET");
		query.append(" ESTABLECIMIENTO = ?, IDENTIFICADOR_ESTABLECIMIENTO = ?");
		query.append(", ID_PROVINCIA = ?, ID_MUNICIPIO = ?, ID_LOCALIDAD = ?");
		query.append(", DIRECCION = ?, NUMERO = ?, ESCALERA = ?, PISO = ?, LETRA = ?, CODIGO_POSTAL = ?");
		query.append(", FECHA_ULTMODIFICACION = SYSDATE, USUARIO_ULTMODIFICACION = ?");
		query.append(" WHERE ID_DIRECCION = ?");

		Object getProvincia = null;
		if (datosDireccion.getProvincia() != null && datosDireccion.getProvincia().getId() != null) {
			getProvincia = datosDireccion.getProvincia().getId();
		}
		Object getMunicipio = null;
		if (datosDireccion.getMunicipio() != null && datosDireccion.getMunicipio().getId() != null) {
			getMunicipio = datosDireccion.getMunicipio().getId();
		}
		Object getLocalidad = null;
		if (datosDireccion.getLocalidad() != null && datosDireccion.getLocalidad().getId() != null) {
			getLocalidad = datosDireccion.getLocalidad().getId();
		}

		this.jdbcTemplate.update(query.toString(), datosDireccion.getEstablecimiento(),
				datosDireccion.getIdentificadorEstablecimiento(), getProvincia, getMunicipio, getLocalidad,
				datosDireccion.getDireccion(), datosDireccion.getNumero(), datosDireccion.getEscalera(),
				datosDireccion.getPiso(), datosDireccion.getLetra(), datosDireccion.getCodigoPostal(),
				datosDireccion.getUsuarioUltmodificacion(), datosDireccion.getIdDireccion());

		return datosDireccion;
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	@Override
	public DatosDirecciones findDireccionByTerceroTipoDireccion(DatosTerceros datosTercero, int direccionCanalPostal) {
		String query = "SELECT t6136.ID_DIRECCION IDDIRECCION FROM DATOS_DIRECCIONES t6136 WHERE t6136.ID_TIPO_DIRECCION = ? AND t6136.ID_TERCERO = ?";

		List<Object> params = new ArrayList<Object>();
		params.add(direccionCanalPostal);
		params.add(datosTercero.getIdTercero());

		List<DatosDirecciones> datosdireccionesList = this.jdbcTemplate.query(query, this.rwMapPK, params.toArray());
		return DataAccessUtils.uniqueResult(datosdireccionesList);
	}
}
