package com.ejie.ab59.dao.expedientes;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.model.expedientes.DatosDirecciones;
import com.ejie.ab59.model.expedientes.DatosTerceros;

/**
 * 
 *  
 *
 */

public interface DatosDireccionesDao {

	/**
	 * Borrar la dirección de una sanción
	 *
	 * @param idTercero
	 *            Integer
	 * @return
	 */
	void removeDireccionesTerceroPostal(Integer idTercero);

	/**
	 * Inserts a single row in the DatosDirecciones table.
	 *
	 * @param datosDirecciones
	 *            DatosDirecciones
	 * @return DatosDirecciones
	 */
	DatosDirecciones add(DatosDirecciones datosDirecciones);

	/**
	 * Inserts a single row in the DatosDirecciones table.
	 *
	 * @param datosDirecciones
	 *            DatosDirecciones
	 * @return DatosDirecciones
	 */
	DatosDirecciones update(DatosDirecciones datosDirecciones);

	/**
	 * Removes a single row in the DatosDirecciones table.
	 *
	 * @param datosDirecciones
	 *            DatosDirecciones
	 * @return
	 */
	public void remove(DatosDirecciones datosDirecciones);

	/**
	 * Buscar la dirección asociada a la sanción
	 *
	 * @param idSancion
	 *            Integer
	 * 
	 * @return DatosDirecciones
	 */
	DatosDirecciones findDireccion(Integer idSancion);

	/**
	 * Buscar la direcciónes asociadas a la sanción
	 *
	 * @param idSancion
	 *            Integer
	 * 
	 * @return List<DatosDirecciones>
	 */
	@Transactional(readOnly = true)
	public List<DatosDirecciones> findDireccionesSancion(Integer idSancion);

	/**
	 * Updates a single row in the Sanciones table.
	 *
	 * @param datosDireccion
	 *            DatosDirecciones
	 * @return DatosDirecciones
	 */
	DatosDirecciones updateUbicacion(DatosDirecciones datosDireccion);

	List<DatosDirecciones> findDireccionesSancionEstablecimiento(Integer idSancion,
			String identificadorEstablecimiento);

	DatosDirecciones buscarEstablecimiento(String numeroRegistro);

	DatosDirecciones findDireccionByTerceroTipoDireccion(DatosTerceros datosTercero, int direccionCanalPostal);
}
