package com.ejie.ab59.dao.expedientes;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.model.expedientes.CanalesAviso;
import com.ejie.ab59.model.expedientes.DatosTerceros;
import com.ejie.ab59.model.expedientes.TiposCanalAviso;

@Repository
@Transactional
public class CanalesAvisoDaoImpl implements CanalesAvisoDao {

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<CanalesAviso> rwMap = new RowMapper<CanalesAviso>() {
		@Override
		public CanalesAviso mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			CanalesAviso canalAviso = new CanalesAviso();
			canalAviso.setIdCanalAviso(
					resultSet.getObject("IDCANALAVISO") != null ? resultSet.getInt("IDCANALAVISO") : null);
			canalAviso.setCanalAviso(
					resultSet.getObject("CANALAVISO") != null ? resultSet.getString("CANALAVISO") : null);

			TiposCanalAviso tipoCanalAviso = new TiposCanalAviso();
			tipoCanalAviso.setIdTipoCanalAviso(
					resultSet.getObject("IDTIPOCANALAVISO") != null ? resultSet.getInt("IDTIPOCANALAVISO") : null);
			canalAviso.setTipoCanalAviso(tipoCanalAviso);

			return canalAviso;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	@Override
	public CanalesAviso findByTerceroTipoCanalAviso(DatosTerceros datosTercero, int tipoCanalAviso) {
		StringBuilder query = new StringBuilder();
		query.append(
				"SELECT t6116.ID_CANAL_AVISO IDCANALAVISO, t6116.ID_TIPO_CANAL_AVISO IDTIPOCANALAVISO, t6116.CANAL_AVISO CANALAVISO FROM CANALES_AVISO t6116 WHERE t6116.ID_DATO_TERCERO = ? AND t6116.ID_TIPO_CANAL_AVISO = ?");

		List<Object> params = new ArrayList<Object>();
		params.add(datosTercero.getIdTercero());
		params.add(tipoCanalAviso);

		List<CanalesAviso> listaCanalesAviso = this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
		return DataAccessUtils.uniqueResult(listaCanalesAviso);
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
