package com.ejie.ab59.dao.configuracionInicioOficio;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.model.configuracionInicioOficio.AlcancesResolucion;
import com.ejie.ab59.model.configuracionInicioOficio.RelIniOfiAlcRes;
import com.ejie.ab59.model.tablasMaestras.ConfIniOfi;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableRequestDto;

/**
 * 
 *  
 *
 */

@Repository
@Transactional
public class RelIniOfiAlcResDaoImpl implements RelIniOfiAlcResDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "ID_REL_INI_OFI_ALC_RES", "ID_CONF_INI_OFI",
			"ID_ALCANCE_RESOLUCION", "FECHA_REGISTRO", "USUARIO_REGISTRO" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<RelIniOfiAlcRes> rwMap = new RowMapper<RelIniOfiAlcRes>() {
		public RelIniOfiAlcRes mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			RelIniOfiAlcRes relIniOfiAlcRes = new RelIniOfiAlcRes();

			AlcancesResolucion alcancesResolucion = new AlcancesResolucion();
			alcancesResolucion.setIdAlcanceResolucion(resultSet.getLong("IDALCANCERESOLUCION"));

			ConfIniOfi confIniOfi = new ConfIniOfi();
			confIniOfi.setIdConfiguracion(resultSet.getLong("IDCONFINIOFI"));

			relIniOfiAlcRes.setIdRelIniOfiAlcRes(resultSet.getLong("IDRELINIOFIALCRES"));
			relIniOfiAlcRes.setConfIniOfi(confIniOfi);
			relIniOfiAlcRes.setAlcancesResolucion(alcancesResolucion);
			relIniOfiAlcRes.setFechaRegistro(resultSet.getDate("FECHAREGISTRO"));
			relIniOfiAlcRes.setUsuarioRegistro(resultSet.getString("USUARIOREGISTRO"));

			return relIniOfiAlcRes;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	@Override
	public RelIniOfiAlcRes add(RelIniOfiAlcRes relIniOfiAlcRes) {

		String query = "INSERT INTO REL_INI_OFI_ALC_RES (ID_REL_INI_OFI_ALC_RES, ID_CONF_INI_OFI, ID_ALCANCE_RESOLUCION, FECHA_REGISTRO, USUARIO_REGISTRO) "
				+ "VALUES (?,?,?,?,?)";

		relIniOfiAlcRes.setIdRelIniOfiAlcRes(
				this.jdbcTemplate.queryForObject("SELECT AB59.S_AB5922T00.NEXTVAL FROM DUAL", Long.class));

		this.jdbcTemplate.update(query, relIniOfiAlcRes.getIdRelIniOfiAlcRes(),
				relIniOfiAlcRes.getConfIniOfi().getIdConfiguracion(),
				relIniOfiAlcRes.getAlcancesResolucion().getIdAlcanceResolucion(), new Date(),
				relIniOfiAlcRes.getUsuarioRegistro());

		return relIniOfiAlcRes;
	}

	@Override
	public RelIniOfiAlcRes update(RelIniOfiAlcRes relIniOfiAlcRes) {

		String query = "UPDATE REL_INI_OFI_ALC_RES SET ID_CONF_INI_OFI = ?, ID_ALCANCE_RESOLUCION = ? WHERE ID_REL_INI_OFI_ALC_RES = ?";
		this.jdbcTemplate.update(query, relIniOfiAlcRes.getConfIniOfi().getIdConfiguracion(),
				relIniOfiAlcRes.getAlcancesResolucion().getIdAlcanceResolucion(),
				relIniOfiAlcRes.getIdRelIniOfiAlcRes());

		return relIniOfiAlcRes;
	}

	@Override
	public void remove(RelIniOfiAlcRes relIniOfiAlcRes) {
		String query = "DELETE FROM REL_INI_OFI_ALC_RES WHERE ID_REL_INI_OFI_ALC_RES = ?";
		this.jdbcTemplate.update(query, relIniOfiAlcRes.getIdRelIniOfiAlcRes());
	}

	@Override
	public void removeByConfIniOfi(ConfIniOfi confIniOfi) {
		String query = "DELETE FROM REL_INI_OFI_ALC_RES WHERE ID_CONF_INI_OFI = ?";
		this.jdbcTemplate.update(query, confIniOfi.getIdConfiguracion());
	}

	@Override
	@Transactional(readOnly = true)
	public RelIniOfiAlcRes find(RelIniOfiAlcRes relIniOfiAlcRes) {
		String query = "SELECT t5922.ID_REL_INI_OFI_ALC_RES IDRELINIOFIALCRES, t5922.ID_CONF_INI_OFI IDCONFINIOFI, t5922.ID_ALCANCE_RESOLUCION IDALCANCERESOLUCION, "
				+ " t5922.FECHA_REGISTRO FECHAREGISTRO, t5922.USUARIO_REGISTRO USUARIOREGISTRO "
				+ " FROM REL_INI_OFI_ALC_RES t5922  WHERE t5922.ID_REL_INI_OFI_ALC_RES = ? ";

		List<RelIniOfiAlcRes> relIniOfiAlcResList = this.jdbcTemplate.query(query, this.rwMap,
				relIniOfiAlcRes.getIdRelIniOfiAlcRes());
		return (RelIniOfiAlcRes) DataAccessUtils.uniqueResult(relIniOfiAlcResList);
	}

	@Override
	@Transactional(readOnly = true)
	public List<RelIniOfiAlcRes> findAll(RelIniOfiAlcRes relIniOfiAlcRes, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder();

		query.append(
				" SELECT t5922.ID_REL_INI_OFI_ALC_RES IDRELINIOFIALCRES, t5922.ID_CONF_INI_OFI IDCONFINIOFI, t5922.ID_ALCANCE_RESOLUCION IDALCANCERESOLUCION, ");
		query.append(" t5922.FECHA_REGISTRO FECHAREGISTRO, t5922.USUARIO_REGISTRO USUARIOREGISTRO ");
		query.append(" FROM REL_INI_OFI_ALC_RES t5922 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(relIniOfiAlcRes);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query, RelIniOfiAlcResDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	@Override
	@Transactional(readOnly = true)
	public Long findAllCount(RelIniOfiAlcRes relIniOfiAlcRes) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM REL_INI_OFI_ALC_RES t5922 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(relIniOfiAlcRes);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	private Map<String, ?> getWhereMap(RelIniOfiAlcRes relIniOfiAlcRes) {

		StringBuilder where = new StringBuilder(RelIniOfiAlcResDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (relIniOfiAlcRes != null && relIniOfiAlcRes.getIdRelIniOfiAlcRes() != null) {
			where.append(" AND t5922.ID_REL_INI_OFI_ALC_RES = ?");
			params.add(relIniOfiAlcRes.getIdRelIniOfiAlcRes());
		}
		if (relIniOfiAlcRes != null && relIniOfiAlcRes.getConfIniOfi() != null
				&& relIniOfiAlcRes.getConfIniOfi().getIdConfiguracion() != null) {
			where.append(" AND t5922.ID_CONF_INI_OFI = ?");
			params.add(relIniOfiAlcRes.getConfIniOfi().getIdConfiguracion());
		}
		if (relIniOfiAlcRes != null && relIniOfiAlcRes.getAlcancesResolucion() != null
				&& relIniOfiAlcRes.getAlcancesResolucion().getIdAlcanceResolucion() != null) {
			where.append(" AND t5922.ID_ALCANCE_RESOLUCION = ?");
			params.add(relIniOfiAlcRes.getAlcancesResolucion().getIdAlcanceResolucion());
		}
		if (relIniOfiAlcRes != null && relIniOfiAlcRes.getFechaRegistro() != null) {
			where.append(" AND t5922.FECHA_REGISTRO = ?");
			params.add(relIniOfiAlcRes.getFechaRegistro());
		}
		if (relIniOfiAlcRes != null && relIniOfiAlcRes.getUsuarioRegistro() != null) {
			where.append(" AND t5922.USUARIO_REGISTRO = ?");
			params.add(relIniOfiAlcRes.getUsuarioRegistro());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	public static final int STRING_BUILDER_INIT = 4096;

}
