package com.ejie.ab59.dao.configuracionInicioOficio;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.clientesWS.ab61WebService.Firmantes;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableRequestDto;

/**
 * 
 *  
 *
 */

@Repository
@Transactional
public class FirmantesDaoImpl implements FirmantesDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDFIRMANTE", "IDENTIFICADOR", "NOMBRE", "BUZON",
			"IDTERRITORIOHISTORICO", "FECHAREGISTRO", "USUARIOREGISTRO", "FECHAULTMODIFICACION",
			"USUARIOULTMODIFICACION", "APELLIDO1", "APELLIDO2" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Firmantes> rwMap = new RowMapper<Firmantes>() {
		public Firmantes mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Firmantes firmantes = new Firmantes();
			firmantes.setIdFirmante(resultSet.getInt("IDFIRMANTE"));
			firmantes.setIdentificador(resultSet.getString("IDENTIFICADOR"));
			firmantes.setNombreFirmante(resultSet.getString("NOMBRE"));
			firmantes.setBuzon(resultSet.getString("BUZON"));
			firmantes.setIdTerritorioHistorico(resultSet.getInt("IDTERRITORIOHISTORICO"));
			firmantes.setUsuarioRegistro(resultSet.getString("USUARIOREGISTRO"));
			firmantes.setUsuarioUltmodificacion(resultSet.getString("USUARIOULTMODIFICACION"));
			firmantes.setApellido1(resultSet.getString("APELLIDO1"));
			firmantes.setApellido2(resultSet.getString("APELLIDO2"));

			return firmantes;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	@Override
	public Firmantes add(Firmantes firmantes) {

		String query = "INSERT INTO FIRMANTES (ID_FIRMANTE, IDENTIFICADOR, NOMBRE, BUZON, ID_TERRITORIO_HISTORICO, FECHA_REGISTRO, USUARIO_REGISTRO, APELLIDO1, APELLIDO2) VALUES (?,?,?,?,?,?,sysdate,?,?)";

		firmantes.setIdFirmante(
				this.jdbcTemplate.queryForObject("SELECT AB61.S_AB6156T00.NEXTVAL FROM DUAL", Integer.class));

		this.jdbcTemplate.update(query, firmantes.getIdFirmante(), firmantes.getIdentificador(),
				firmantes.getNombreFirmante(), firmantes.getBuzon(), firmantes.getIdTerritorioHistorico(),
				firmantes.getApellido1(), firmantes.getApellido2());

		return firmantes;
	}

	@Override
	public Firmantes update(Firmantes firmantes) {

		String query = "UPDATE FIRMANTES SET IDENTIFICADOR = ?, NOMBRE = ?, BUZON = ?, ID_TERRITORIO_HISTORICO = ?, "
				+ " FECHA_ULTMODIFICACION = ?, USUARIO_ULTMODIFICACION = ?, APELLIDO1 = ?, APELLIDO2 = ? WHERE ID_FIRMANTE = ?";

		this.jdbcTemplate.update(query, firmantes.getIdentificador(), firmantes.getNombreFirmante(),
				firmantes.getBuzon(), firmantes.getIdTerritorioHistorico(), new Date(),
				firmantes.getUsuarioUltmodificacion(), firmantes.getApellido1(), firmantes.getApellido2(),
				firmantes.getIdFirmante());

		return firmantes;
	}

	@Override
	public void remove(Firmantes firmantes) {
		String query = "DELETE FROM FIRMANTES WHERE ID_FIRMANTE = ?";
		this.jdbcTemplate.update(query, firmantes.getIdFirmante());
	}

	@Override
	@Transactional(readOnly = true)
	public Firmantes find(Firmantes firmantes) {

		String query = "SELECT t6156.ID_FIRMANTE IDFIRMANTE, t6156.IDENTIFICADOR , t6156.NOMBRE, t6156.BUZON, t6156.ID_TERRITORIO_HISTORICO IDTERRITORIOHISTORICO, "
				+ " t6156.FECHA_REGISTRO FECHAREGISTRO, USUARIO_REGISTRO USUARIOREGISTRO"
				+ " t6156.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, t6156.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, "
				+ " t6156.APELLIDO1, t6156.APELLIDO2 FROM FIRMANTES t6156 WHERE t6156.ID_FIRMANTE = ?";

		List<Firmantes> firmantesList = this.jdbcTemplate.query(query, this.rwMap, firmantes.getIdFirmante());
		return (Firmantes) DataAccessUtils.uniqueResult(firmantesList);
	}

	@Override
	@Transactional(readOnly = true)
	public List<Firmantes> findAll(Firmantes firmantes, TableRequestDto tableRequestDto) {

		StringBuilder query = new StringBuilder();

		query.append(
				"SELECT t6156.ID_FIRMANTE IDFIRMANTE, t6156.IDENTIFICADOR , t6156.NOMBRE, t6156.BUZON, t6156.ID_TERRITORIO_HISTORICO IDTERRITORIOHISTORICO, t6156.FECHA_REGISTRO FECHAREGISTRO, "
						+ " t6156.USUARIO_REGISTRO USUARIOREGISTRO, t6156.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, "
						+ " t6156.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, t6156.APELLIDO1, t6156.APELLIDO2 ");
		query.append(" FROM FIRMANTES t6156");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(firmantes);
		StringBuilder where = new StringBuilder(" WHERE 1=1");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query, FirmantesDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	@Override
	@Transactional(readOnly = true)
	public Long findAllCount(Firmantes firmantes) {

		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM FIRMANTES ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(firmantes);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	private Map<String, ?> getWhereMap(Firmantes firmantes) {

		StringBuilder where = new StringBuilder(FirmantesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (firmantes != null && firmantes.getIdFirmante() != null) {
			where.append(" AND t6156.ID_FIRMANTE = ?");
			params.add(firmantes.getIdFirmante());
		}
		if (firmantes != null && firmantes.getIdentificador() != null) {
			where.append(" AND t6156.IDENTIFICADOR = ?");
			params.add(firmantes.getIdentificador());
		}
		if (firmantes != null && firmantes.getNombreFirmante() != null) {
			where.append(" AND t6156.NOMBRE = ?");
			params.add(firmantes.getNombreFirmante());
		}
		if (firmantes != null && firmantes.getBuzon() != null) {
			where.append(" AND t6156.BUZON = ?");
			params.add(firmantes.getBuzon());
		}
		if (firmantes != null && firmantes.getIdTerritorioHistorico() != null) {
			where.append(" AND t6156.ID_TERRITORIO_HISTORICO = ?");
			params.add(firmantes.getIdTerritorioHistorico());
		}
		if (firmantes != null && firmantes.getUsuarioRegistro() != null) {
			where.append(" AND t6156.USUARIO_REGISTRO = ?");
			params.add(firmantes.getUsuarioRegistro());
		}
		if (firmantes != null && firmantes.getUsuarioUltmodificacion() != null) {
			where.append(" AND t6156.USUARIO_ULTMODIFICACION = ?");
			params.add(firmantes.getUsuarioUltmodificacion());
		}
		if (firmantes != null && firmantes.getApellido1() != null) {
			where.append(" AND t6156.APELLIDO1 = ?");
			params.add(firmantes.getApellido1());
		}
		if (firmantes != null && firmantes.getApellido2() != null) {
			where.append(" AND t6156.APELLIDO2 = ?");
			params.add(firmantes.getApellido2());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	public static final int STRING_BUILDER_INIT = 4096;

}
