package com.ejie.ab59.dao.configuracionInicioOficio;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.TableRequestDto;
import com.ejie.ab59.model.configuracionInicioOficio.AlcancesResolucion;
import com.ejie.x38.dto.TableManager;

/**
 * 
 *  
 *
 */

@Repository
@Transactional
public class AlcancesResolucionDaoImpl implements AlcancesResolucionDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "ID_ALCANCE_RESOLUCION", "DESCRIPCION_CASTELLANO",
			"DESCRIPCION_EUSKERA", "FECHA_REGISTRO", "USUARIO_REGISTRO" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<AlcancesResolucion> rwMap = new RowMapper<AlcancesResolucion>() {
		public AlcancesResolucion mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			AlcancesResolucion alcancesResolucion = new AlcancesResolucion();
			alcancesResolucion.setIdAlcanceResolucion(resultSet.getLong("IDALCANCERESOLUCION"));
			alcancesResolucion.setDescripcionCastellano(resultSet.getString("DESCRIPCIONCASTELLANO"));
			alcancesResolucion.setDescripcionEuskera(resultSet.getString("DESCRIPCIONEUSKERA"));
			alcancesResolucion.setFechaRegistro(resultSet.getDate("FECHAREGISTRO"));
			alcancesResolucion.setUsuarioRegistro(resultSet.getString("USUARIOREGISTRO"));

			return alcancesResolucion;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	@Override
	public AlcancesResolucion update(AlcancesResolucion alcancesResolucion) {
		String query = "UPDATE ALCANCES_RESOLUCION SET DESCRIPCION_CASTELLANO = ?, DESCRIPCION_EUSKERA = ? WHERE ID_ALCANCE_RESOLUCION = ?";
		this.jdbcTemplate.update(query, alcancesResolucion.getDescripcionCastellano(),
				alcancesResolucion.getDescripcionEuskera(), alcancesResolucion.getUsuarioRegistro());
		return alcancesResolucion;
	}

	@Override
	public void remove(AlcancesResolucion alcancesResolucion) {
		String query = "DELETE FROM ALCANCES_RESOLUCION WHERE ID_ALCANCE_RESOLUCION = ?";
		this.jdbcTemplate.update(query, alcancesResolucion.getIdAlcanceResolucion());
	}

	@Override
	@Transactional(readOnly = true)
	public AlcancesResolucion find(AlcancesResolucion alcancesResolucion) {
		String query = "SELECT t5921.ID_ALCANCE_RESOLUCION IDALCANCERESOLUCION, t5921.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, t5921.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA, "
				+ " t5921.FECHA_REGISTRO FECHAREGISTRO, t5921.USUARIO_REGISTRO USUARIOREGISTRO "
				+ " FROM ALCANCES_RESOLUCION t5921  WHERE t5921.ID_ALCANCE_RESOLUCION = ? ";

		List<AlcancesResolucion> alcancesResolucionList = this.jdbcTemplate.query(query, this.rwMap,
				alcancesResolucion.getIdAlcanceResolucion());
		return (AlcancesResolucion) DataAccessUtils.uniqueResult(alcancesResolucionList);
	}

	@Override
	@Transactional(readOnly = true)
	public List<AlcancesResolucion> findAll(AlcancesResolucion alcancesResolucion, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder();

		query.append(
				"SELECT t5921.ID_ALCANCE_RESOLUCION IDALCANCERESOLUCION, t5921.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, t5921.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA, "
						+ " t5921.FECHA_REGISTRO FECHAREGISTRO, t5921.USUARIO_REGISTRO USUARIOREGISTRO ");
		query.append(" FROM ALCANCES_RESOLUCION t5921");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(alcancesResolucion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query,
					AlcancesResolucionDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	@Override
	@Transactional(readOnly = true)
	public Long findAllCount(AlcancesResolucion alcancesResolucion) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ALCANCES_RESOLUCION t5921 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(alcancesResolucion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	private Map<String, ?> getWhereMap(AlcancesResolucion alcancesResolucion) {

		StringBuilder where = new StringBuilder(AlcancesResolucionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (alcancesResolucion != null && alcancesResolucion.getIdAlcanceResolucion() != null) {
			where.append(" AND t5921.ID_ALCANCE_RESOLUCION = ?");
			params.add(alcancesResolucion.getIdAlcanceResolucion());
		}
		if (alcancesResolucion != null && alcancesResolucion.getDescripcionCastellano() != null) {
			where.append(" AND t5921.DESCRIPCION_CASTELLANO = ?");
			params.add(alcancesResolucion.getDescripcionCastellano());
		}
		if (alcancesResolucion != null && alcancesResolucion.getDescripcionEuskera() != null) {
			where.append(" AND t5921.DESCRIPCION_EUSKERA = ?");
			params.add(alcancesResolucion.getDescripcionEuskera());
		}
		if (alcancesResolucion != null && alcancesResolucion.getFechaRegistro() != null) {
			where.append(" AND t5921.FECHA_REGISTRO = ?");
			params.add(alcancesResolucion.getFechaRegistro());
		}
		if (alcancesResolucion != null && alcancesResolucion.getUsuarioRegistro() != null) {
			where.append(" AND t5921.USUARIO_REGISTRO = ?");
			params.add(alcancesResolucion.getUsuarioRegistro());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	public static final int STRING_BUILDER_INIT = 4096;

}
