package com.ejie.ab59.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.model.Intervalos;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableRequestDto;

@Repository
@Transactional
public class IntervalosDaoImpl implements IntervalosDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDINTERVALO", "FECHAINICIO", "FECHAFIN",
			"NUMERODIAS", "FECHAREGISTRO", "USUARIOREGISTRO" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Intervalos> rwMap = new RowMapper<Intervalos>() {
		public Intervalos mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Intervalos retorno = new Intervalos();
			retorno.setIdIntervalo(
					(resultSet.getObject("IDINTERVALO") != null ? resultSet.getInt("IDINTERVALO") : null));
			retorno.setFechaInicio(resultSet.getDate("FECHAINICIO"));
			retorno.setFechaFin(resultSet.getDate("FECHAFIN"));
			retorno.setNumeroDias((resultSet.getObject("NUMERODIAS") != null ? resultSet.getInt("NUMERODIAS") : null));

			return retorno;
		}
	};

	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	@Transactional(readOnly = true)
	@Override
	public List<Intervalos> findAllLike(Intervalos intervalos, TableRequestDto tableRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_INTERVALO IDINTERVALO, t1.FECHA_INICIO FECHAINICIO, t1.FECHA_FIN FECHAFIN, t1.NUMERO_DIAS NUMERODIAS ");
		query.append("FROM INTERVALOS t1 ");

		Map<String, ?> mapaWhere = this.getWhereLikeMap(intervalos, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query, IntervalosDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	@Transactional(readOnly = true)
	@Override
	public List<Intervalos> buscarIntervalosEntreFechaInicioYFin(Date fechaInicio, Date fechaFin) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_INTERVALO IDINTERVALO, t1.FECHA_INICIO FECHAINICIO, t1.FECHA_FIN FECHAFIN, t1.NUMERO_DIAS NUMERODIAS "
						+ " FROM INTERVALOS t1 WHERE ? BETWEEN TRUNC(t1.FECHA_INICIO) AND TRUNC(t1.FECHA_FIN) "
						+ " OR ? BETWEEN TRUNC(t1.FECHA_INICIO) AND TRUNC(t1.FECHA_FIN) "
						+ " OR TRUNC(t1.FECHA_INICIO) BETWEEN ? AND ? OR TRUNC(t1.FECHA_FIN) BETWEEN ? AND ?");

		List<Object> params = new ArrayList<Object>();
		params.add(fechaInicio);
		params.add(fechaFin);
		params.add(fechaInicio);
		params.add(fechaFin);
		params.add(fechaInicio);
		params.add(fechaFin);

		return this.jdbcTemplate.query(query.toString(), params.toArray(), this.rwMap);
	}

	private Map<String, Object> getWhereLikeMap(Intervalos intervalos, Boolean startsWith) {

		StringBuilder where = new StringBuilder(IntervalosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (intervalos != null && intervalos.getIdIntervalo() != null) {
			where.append(" AND t1.ID_INTERVALO = ?");
			params.add(intervalos.getIdIntervalo());
		}
		if (intervalos != null && intervalos.getFechaInicio() != null) {
			where.append(" AND t1.FECHA_INICIO = ?");
			params.add(intervalos.getFechaInicio());
		}
		if (intervalos != null && intervalos.getFechaFin() != null) {
			where.append(" AND t1.FECHA_FIN = ?");
			params.add(intervalos.getFechaFin());
		}
		if (intervalos != null && intervalos.getNumeroDias() != null) {
			where.append(" AND t1.NUMERO_DIAS = ?");
			params.add(intervalos.getNumeroDias());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
