package com.ejie.ab59.comun;

import java.io.Serializable;

import javax.servlet.http.HttpServletRequest;

import org.springframework.security.core.Authentication;

import com.ejie.ab59.clientesWS.ab61WebService.Usuario;
import com.ejie.x38.security.UserCredentials;

public class UtilUsuario implements Serializable {
	private static final long serialVersionUID = -2475753367190285685L;

	/**
	 * Constructor
	 */
	private UtilUsuario() {
		super();
	}

	public static Usuario getUsuario(Authentication aut, HttpServletRequest httpRequest) {

		Usuario usuario = new Usuario();

		if (null != aut) {

			UserCredentials credentials = (UserCredentials) aut.getCredentials();
			usuario.setUsuario(aut.getName());

			String dni = credentials.getNif();

			String dniLetra = calcularLetra(dni);

			if (dniLetra != null) {
				usuario.setIdentificador(dniLetra);

			} else
				// Si tenemos un usuario ficticio, no tenemos NIF con lo que
				// pondremos el Nombre en el Identificador
				usuario.setIdentificador(usuario.getUsuario());

			if (credentials.getName() != null) {
				usuario.setNombreUsuario(credentials.getName());
			}
			if (credentials.getSurname() != null && !"".equals(credentials.getSurname())) {
				usuario.setPrimerApellido(credentials.getSurname());
			}

			usuario.setBuzon(UtilsXlnets.obtenerLogin(httpRequest));

		}

		return usuario;

	}

	private static String calcularLetra(String dni) {

		String caracteres = "TRWAGMYFPDXBNJZSQVHLCKE";
		String dniLetra = null;

		try {
			int resto = Integer.parseInt(dni) % 23;
			dniLetra = dni + caracteres.charAt(resto);

		} catch (NumberFormatException e) {

			dniLetra = null;
		}

		return dniLetra;
	}
}
