package com.ejie.ab59.comun;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import org.springframework.context.i18n.LocaleContextHolder;

public class UtilDate implements Serializable {

	/**
	 * Funcion que devuelve un Date en String
	 */
	public static String convertirFechaEnString(Date fecha) {
		if (fecha != null) {
			if (LocaleContextHolder.getLocale().toString().equals("es")) {
				return (new SimpleDateFormat("dd/MM/yyyy")).format(fecha);
			} else {
				return (new SimpleDateFormat("yyyy/MM/dd")).format(fecha);
			}
		} else {
			return "";
		}
	}

	public static String convertirFechaEnStringConHora(Date fecha) {
		if (fecha != null) {
			if ("es".equalsIgnoreCase(LocaleContextHolder.getLocale().toString())) {
				return (new SimpleDateFormat("dd/MM/yyyy HH:mm:ss")).format(fecha);
			} else {
				return (new SimpleDateFormat("yyyy/MM/dd HH:mm:ss")).format(fecha);
			}
		} else {
			return "";
		}
	}

	public static String convertirFechaEnStringConFormato(Date fecha, String formato) {
		if (fecha != null) {
			return (new SimpleDateFormat(formato)).format(fecha);
		} else {
			return "";
		}
	}

	/**
	 * Funcion que devuelve un String en Date
	 */
	public static Date convertirFechaEnDate(String fecha) {

		try {
			if (fecha != null && !fecha.equals("")) {
				if (LocaleContextHolder.getLocale().toString().equals("es")) {
					return (new SimpleDateFormat("dd/MM/yyyy")).parse(fecha);
				} else {
					return (new SimpleDateFormat("yyyy/MM/dd")).parse(fecha);
				}
			} else {
				return null;
			}
		} catch (Exception e) {
			return null;
		}
	}

	public static Date convertirFechaConHoraEnDate(String fecha) {

		try {
			if (fecha != null && !fecha.equals("")) {
				if ("es".equalsIgnoreCase(LocaleContextHolder.getLocale().toString())) {
					return (new SimpleDateFormat("dd/MM/yyyy HH:mm:ss")).parse(fecha);
				} else {
					return (new SimpleDateFormat("yyyy/MM/dd HH:mm:ss")).parse(fecha);
				}
			} else {
				return null;
			}
		} catch (Exception e) {
			return null;
		}
	}

	public static Date convertirFechaConFormatoEnDate(String fecha, String formato) {

		try {
			if (fecha != null && !fecha.equals("")) {
				return (new SimpleDateFormat(formato)).parse(fecha);
			} else {
				return null;
			}
		} catch (Exception e) {
			return null;
		}
	}

	public static String formatearMiles(BigDecimal valor) {
		if (valor != null) {
			return localizedFormat("###,##0.00", valor.doubleValue(), new Locale("es", "ES"));
		} else
			return "";
	}

	private static String localizedFormat(String pattern, double value, Locale loc) {
		NumberFormat nf = NumberFormat.getNumberInstance(loc);
		DecimalFormat df = (DecimalFormat) nf;
		df.applyPattern(pattern);
		return df.format(value);
	}

}
