package com.ejie.ab59.comun;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public abstract class SeguridadAplicacion {

	/**
	 * Instancias / roles de los usuarios
	 */
	public static String ROLE_AB59_ADMINISTRADOR = "ROLE_AB59-IN-0001";
	public static String ROLE_LAKUA_TURISMO = "ROLE_AB59-IN-0005";
	public static String ROLE_LAKUA_COMERCIO = "ROLE_AB59-IN-0009";
	public static String ROLE_PERFIL_CONSULTA = "ROLE_AB59-IN-0011";

	/**
	 * Usuarios de la aplicacin
	 * 
	 * 	AB59U001: Administrador
	 *	AB59U005: Usuario de Lakua para Turismo
	 *	AB59U006: Perfil de Consulta (Propuesta de Sancin)
	 *	AB59U009: Usuario de Lakua para Comercio
	 */
	
	
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 7601398309596598460L;

	/**
	 * 
	 * @param authentication
	 *            org.springframework.security.core.Authentication
	 * @return Vector<String> con los roles del usuario
	 */
	public static Vector<String> getRolesUsuario(Authentication authentication) {
		Vector<String> vecPermisos = new Vector<String>();
		if (authentication != null) {
			List<GrantedAuthority> list = new ArrayList<GrantedAuthority>(authentication.getAuthorities());
			for (GrantedAuthority grantedAuthority : list) {
				vecPermisos.add(grantedAuthority.getAuthority());
			}
		}
		return vecPermisos;
	}

	/**
	 * 
	 * @param authentication
	 *            org.springframework.security.core.Authentication
	 * @return String dirección para indicar que dirección se debe precargar
	 *         en la búsqueda de inspecciones
	 */
	public static String precargarDireccion() {

		String direccion = "";

		Vector<String> vecPermisos = SeguridadAplicacion
				.getRolesUsuario(SecurityContextHolder.getContext().getAuthentication());

		// Si pertenece a turismo
		if (vecPermisos.contains(ROLE_LAKUA_TURISMO)) {
			direccion = String.valueOf(Constantes.ID_TURISMO_DIRECCION);

			// Si pretenece a Comercio
		} else if (vecPermisos.contains(ROLE_LAKUA_COMERCIO)) {
			direccion = String.valueOf(Constantes.ID_COMERCIO_DIRECCION);
		}
		return direccion;
	}

	public static boolean esPerfilConsulta() {

		Vector<String> vecPermisos = SeguridadAplicacion
				.getRolesUsuario(SecurityContextHolder.getContext().getAuthentication());

		if (vecPermisos.contains(ROLE_PERFIL_CONSULTA)) {
			return true;
		} else {
			return false;
		}
	}

}
