/**
 * JSON con las cadenas traducidas a los diferentes idiomas.
 * No hay espaol, por ser el default.
 */
frases = {
	"es": {
		"escala":					"Escala",		
		"cambiaIdioma":				"Cambiar idioma:",
		"idioma-es":				"Espa&ntilde;ol",
		"idioma-eu":				"Euskara",
		"idioma-en":				"Ingl&eacute;s",
		"zonaGeo":					"Zona geogr&aacute;fica"	,
		"selecionaZonas":			"Seleccionar todas las zonas",
		"cae":						"C.A. <strong>E</strong>uskadi",
		"arab":						"<strong>A</strong>raba/&Aacute;lava",
		"biz":						"<strong>B</strong>izkaia",
		"gip":						"<strong>G</strong>ipuzkoa",
		"indicadores":				"Indicadores",
		"c":						"E",
		"a":						"A",
		"b":						"B",
		"g":						"G",
		"selecionaIndicadores":		"Seleccionar todos los indicadores",
		"animacion":				"Animaci&oacute;n",
		"play":						"play",
		"pause":					"pause",
		"stop":						"stop",
		"repetir":					"Repetir",
		"controlCola":				"Control de cola y tiempo",
		"cola":						"Visualizar traza",
		"tamanioCola":				"Longitud traza",
		"campo1Lineas":				"&Iacute;ndice",
		"campo2Lineas":				"Ciclo tendencia",
		"campo3Lineas":				"Serie desv.",
		"campo4Lineas":				"Tasa de variacin",
		"campo5Lineas":				"Tendencia",
		"campo6Lineas":				"Desviaci&oacute;n del ciclo tendencia sobre la tendencia",
		"desviaTipica":				"Desviaci&oacute;n tipica de la tendencia del ciclo",
		"indic1":					"Producci&oacute;n industrial",		
		"indic2":					"Producci&oacute;n de bienes de consumo",
		"indic3":					"Producci&oacute;n de bienes de equipo",
		"indic4":					"Producci&oacute;n de bienes intermedios",
		"indic5":					"Ventas de otros servicios",
		"indic6":					"Ventas de comercio",
		"indic7":					"Ventas del comercio al por menor",
		"indic8":					"Producci&oacute;n de la industria de la construcci&oacute;n",
		"indic9":					"Importaciones no energ&eacute;ticas",
		"indic10":					"Exportaciones no energ&eacute;ticas",
		"indic11":					"Puestos de trabajo a tiempo completo",
		"indic12":					"Producto interior bruto",		
		"indic13":					"Tasa de paro",
		"colorCAE":					"C.A. Euskadi",
		"colorArab":				"Araba/&Aacute;lava",
		"colorBiz":					"Bizkaia",
		"colorGip":					"Gipuzkoa",
		"forma" :					"Forma",
		"color" :					"Color",
		"ralentizacion":			"Ralentizaci&oacute;n",
		"expansion" :				"Expansi&oacute;n",
		"recesion" :				"Recesi&oacute;n",
		"recuperacion" :			"Recuperaci&oacute;n",
		"zonCAE":					"ZONA : C.A. Euskadi",
		"zonArab":					"ZONA : Araba/&Aacute;lava",
		"zonBiz":					"ZONA : Bizkaia",
		"zonGip":					"ZONA : Gipuzkoa",
		"parrafo":					"El gr&aacute;fico Business Cycle Tracer es un instrumento que permite conocer la evoluci&oacute;n y el estado actual de la econom&iacute;a en la C.A. de Euskadi.<br/>En este sistema de representaci&oacute;n se muestra la evoluci&oacute;n de diferentes &iacute;ndices producidos periodicamente por EUSTAT: &iacute;ndice de comercio al por mayor, indice de comercio al por menor, &iacute;ndice de otros servicios, exportaciones, importaciones, &iacute;ndice de producci&oacute;n industrial etc." ,
		"titleSeries":				"Editar series",
		"titleDatos":				"Mostrar datos",
		"ayuda":					"ayuda",
		"aumTraza":					"Aumentar tama&nacute;o traza",
		"disTraza":					"Disminuir tama&nacute;o traza",
		"mostrarDatos":				"Mostrar datos",
		"editarSeries":				"Editar series",
		"lento":					"Lento",
		"rapido":					"R&aacute;pido",
		"traza":					"Trazas",
		"cicloporencima":			"Sobre la tendencia",
		"ciclopordebajo":			"Bajo la tendencia",
		"decreciendo":				"Decreciendo",
		"creciendo":				"Creciendo"
	},
	"eu": {
		"escala": 					"Eskala",				
		"cambiaIdioma": 			"Hizkuntza aldatu:",
		"idioma-es": 				"Espainia",
		"idioma-eu": 				"Euskara",
		"idioma-en": 				"Ingelesa",
		"zonaGeo": 					"Eremu geografikoa",	
		"selecionaZonas":			"Hautatu eremu guztiak",
		"cae":						"<strong>E</strong>uskal AE",
		"arab":						"<strong>A</strong>raba",
		"biz":						"<strong>B</strong>izkaia",
		"gip":						"<strong>G</strong>ipuzkoa",
		"indicadores":				"Adierazleak",
		"c":						"E",
		"a":						"A",
		"b":						"B",
		"g":						"G",
		"selecionaIndicadores":		"Hautatu adierazle guztiak",
		"animacion":				"Animazioa",
		"play":						"play",
		"pause":					"pause",
		"stop":						"stop",
		"repetir":					"Errepikatu",
		"controlCola":				"Aztarnaren eta denboraren kontrola.",
		"cola":						"Aztarna ikusarazi",
		"tamanioCola":				"Aztarnaren luzera",
		"campo1Lineas":				"Aurkibidea",
		"campo2Lineas":				"Ziklo joera",
		"campo3Lineas":				"Desb. seriea",
		"campo4Lineas":				"Aldakuntza-tasa",
		"campo5Lineas":				"Joera",
		"campo6Lineas":				"Ziklo joeraren desbideratze tipikoa",
		"desviaTipica":				"Ziklo joeraren desbideratze tipikoa",
		"indic1":					"Industri produkzioa",
		"indic2":					"Kontsumo-ondasunen produkzioa",
		"indic3":					"Ekipo-ondasunen produkzioa",
		"indic4":					"Bitarteko ondasunen produkzioa",
		"indic5":					"Bestelako zerbitzuko salmentak",
		"indic6":					"Merkataritzako salmentak",
		"indic7":					"Txikizkako merkataritzako salmentak",
		"indic8":					"Eraikuntza-industriaren produkzioa",
		"indic9":					"Inportazio ez-energetikoak",
		"indic10":					"Esportazio ez-energetikoak",
		"indic11":					"Dedikazio osoko lanpostuak",
		"indic12":					"Barne produktu gordina",
		"indic13":					"Langabezia-tasa",
		"colorCAE":					"Euskal AE",
		"colorArab":				"Araba",
		"colorBiz":					"Bizkaia",
		"colorGip":					"Gipuzkoa",		
		"forma" :					"Forma",
		"color" :					"Kolorea",
		"ralentizacion":			"Mantsotzea",
		"expansion" :				"Hedapena",
		"recesion" :				"Atzeraldia",
		"recuperacion" :			"Susperraldia",
		"zonCAE":					"Eremua: Euskal AE",
		"zonArab":					"Eremua: Araba",
		"zonBiz":					"Eremua: Bizkaia",
		"zonGip":					"Eremua: Gipuzkoa",
		"parrafo":					"Business Cycle Tracer grafikoaren bidez Euskal AEko ekonomiaren bilakaera eta gaur eguneko egoera ezagut dezakegu. Irudikapen honetan Eustatek periodikoki ekoitzitako hainbat indizeren bilakaera erakusten da: Handizkako merkataritzarena, txikizkakoarena, beste zerbitzuena, ",
		"titleSeries":				"Serieak editatu",
		"titleDatos":				"Datuak erakutsi",
		"ayuda":					"laguntza",
		"aumTraza":					"Aztarnaren tamaina handitu",
		"disTraza":					"Aztarnaren tamaina txikitu",
		"mostrarDatos":				"Datuak erakutsi",
		"editarSeries":				"Serieak editatu",
		"lento":					"Geldiro",
		"rapido":					"Azkar",
		"traza":					"Aztarnak",
		"cicloporencima":			"Joeraren gainetik",
		"ciclopordebajo":			"Joeraren azpitik",
		"decreciendo":				"Beherantz",
		"creciendo":				"Gorantz"		
	},
	"en": {
		"escala":					"Scale",				
		"cambiaIdioma":				"Change language:					",
		"idioma-es":				"Spanish",
		"idioma-eu":				"Euskara",
		"idioma-en":				"English",
		"zonaGeo":					"Geographical area",	
		"selecionaZonas":			"Select all areas",
		"cae":						"Basqu<strong>e</strong> Country",
		"arab":						"<strong>A</strong>raba/&Aacute;lava",
		"biz":						"<strong>B</strong>izkaia",
		"gip":						"<strong>G</strong>ipuzkoa",
		"indicadores":				"Indicators",
		"c":						"e",
		"a":						"A",
		"b":						"B",
		"g":						"G",
		"selecionaIndicadores":		"Select all indicators",
		"animacion":				"Animation",
		"play":						"play",
		"pause":					"pause",
		"stop":						"stop",
		"repetir":					"Repeat",
		"controlCola":				"Queue and time control",
		"cola":						"Visualise trace",
		"tamanioCola":				"Trace size",
		"campo1Lineas":				"&Iacute;ndice",
		"campo2Lineas":				"Trend-cycle",
		"campo3Lineas":				"Series dev.",
		"campo4Lineas":				"Variation rate",
		"campo5Lineas":				"Trend",
		"campo6Lineas":				"Typical deviation of the trend-cycle",		
		"desviaTipica":				"Typical deviation of the trend-cycle",
		"indic1":					"Industrial production",
		"indic2":					"Consumer goods production",
		"indic3":					"Capital goods production",
		"indic4":					"Intermediate goods production",
		"indic5":					"Other services sales",
		"indic6":					"Trade sales",
		"indic7":					"Retail trade sales",
		"indic8":					"Construction industry production",
		"indic9":					"Non-energy imports",
		"indic10":					"Non-energy exports",
		"indic11":					"Full-time jobs",
		"indic12":					"Gross domestic product",
		"indic13":					"Unemployment rate",
		"colorCAE":					"Basque Country",
		"colorArab":				"Araba/&Aacute;lava",
		"colorBiz":					"Bizkaia",
		"colorGip":					"Gipuzkoa",		
		"forma" :					"Form",
		"color" :					"Colour",
		"ralentizacion":			"Slowdown",
		"expansion" :				"Expansion",
		"recesion" :				"Recession",
		"recuperacion" :			"Recovery",
		"zonCAE":					"ZONE: Basque Country",
		"zonArab":					"ZONE: Araba/Alava",
		"zonBiz":					"ZONE: Bizkaia",
		"zonGip":					"ZONE: Gipuzkoa",
		"parrafo":					"The Business Cycle Tracer graph is an instrument that allows the evolution and current state of the Basque economy to be understood. This representation system shows the evolution of different indices produced periodically by EUSTAT: Wholesale Trade Index, Retail Trade Index, Other Services Index, exports, imports, Industrial Production Index etc.",
		"titleSeries":				"Edit series",
		"titleDatos":				"Show data",
		"ayuda":					"help",
		"aumTraza":					"Increase trace size",
		"disTraza":					"Reduce graph size",
		"mostrarDatos":				"Show data",
		"editarSeries":				"Edit series",
		"lento":					"Slow",
		"rapido":					"Fast",
		"traza":					"Traces",
		"cicloporencima":			"Above trend",
		"ciclopordebajo":			"Below trend",
		"decreciendo":				"Decreased",
		"creciendo":				"Increased"
	}
};





/**
 * Funci&oacute;n que cambia todos los elementos al nuevo idioma.
 *
 * @param {string} lang
 */
function cambiarIdioma() {
  lang = $("#idioma").val();
  // Habilita las 2 siguientes para guardar la preferencia.
  // lang = lang || sessionStorage.getItem('app-lang') || 'es';
  // sessionStorage.setItem('app-lang', lang);
  // Para que funcione en IE cambiar .dataset.tr por .getAttribute('data-tr')
  
  var elems = document.querySelectorAll('[data-tr]');  
  for (var x = 0; x < elems.length; x++) {
	elems[x].innerHTML = frases.hasOwnProperty(lang)	
      ? frases[lang][elems[x].getAttribute('data-tr')/*.dataset.tr*/]
      : elems[x].getAttribute('data-tr')/*.dataset.tr*/;	  
  }
  var elems = document.querySelectorAll('[data-title]');  
  for (var x = 0; x < elems.length; x++) {	
	elems[x].title = frases.hasOwnProperty(lang)	
      ? frases[lang][elems[x].getAttribute('data-title')/*.dataset.title*/]
      : elems[x].getAttribute('data-title')/*.dataset.title*/;	  
  }
}
