/*
 * Created on 03/10/2008
 *
 */
package s12.validaciones;

import org.apache.commons.validator.Field;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorUtil;
import org.apache.struts.action.ActionErrors;
import javax.servlet.http.HttpServletRequest;
import es.ejie.frmk.presentacion.validacion.Q70ValidacionesGenericas;
import es.ejie.frmk.presentacion.validacion.Q70ValidacionesCampo;;

/**
 *  tica
 * The Class S12Validaciones.
 */
public class S12Validaciones extends Q70ValidacionesGenericas {

	/**
	 *
	 */
	private S12Validaciones(){
		super();
	}

	private static final long serialVersionUID = 5549643934874095168L;

	/**
	 * Validate only text.
	 *
	 * @param bean the bean
	 * @param va the va
	 * @param field the field
	 * @param errors the errors
	 * @param request the request
	 *
	 * @return true, if successful
	 */
	public static boolean validateOnlyText (Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request){

		String regexp = "^([a-zA-Z\\s]{1,}\\s*){1,}$";
		StringBuffer value;
		if (S12Validaciones.isString(bean)) {
			value = new StringBuffer((String) bean);
		} else {
			value = new StringBuffer(ValidatorUtil.getValueAsString(bean, field.getProperty()));
		}

		try{
			if ("pais".equals(field.getProperty())){
				value.append(" ");
			}
			if (!GenericValidator.matchRegexp(value.toString(), regexp)){
				errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
				return false;
			}

		}catch(Exception e){
			errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
			return false;
		}

		return true;

	}

	/**
	 * Validate mails diferentes.
	 *
	 * @param bean the bean
	 * @param va the va
	 * @param field the field
	 * @param errors the errors
	 * @param request the request
	 *
	 * @return true, if successful
	 */
	public static boolean validateMailsDiferentes (Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request){

		String value = null;
		if (S12Validaciones.isString(bean)) {
			value = (String) bean;
		} else {
			value = ValidatorUtil.getValueAsString(bean, field.getProperty());
		}

		try{
			if(errors.isEmpty() && "".equals(value)){
				errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
				return false;
			}

		}catch(Exception e){
			errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
			return false;
		}

		return true;
	}
	/**
	*  Return <code>true</code> if the specified object is a String or a <code>null</code>
	*  value.
	*
	* @param o Object to be tested
	* @return The string value
	*/
   protected static boolean isString(Object o) {
	   return (o == null) ? true : String.class.isInstance(o);
   }
}
