 /* Created on 02-nov-2005
 *
 */
package s12.operacionespresentacion.logotipos;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import bilbofrmk.trasport.BTransport;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
import s12.operacionespresentacion.comun.S12BaseAppInitAction;
import s12.valueObjects.comun.S12Idioma;

/**
 *  
 */
public class S12LogotiposInitAction extends S12BaseAppInitAction{

	/**
	 * Constante que indica el componente al que pertenece dicha clase. Es
	 * necesario para el uso del log de trazas.
	 */
	private static final String COMPONENTE = "LOGOTIPOS";

	private final static int CONST_INIT_LOGOTIPOS = 1;

	/**
	 * Process s12 init op.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.S12BaseAction#processS12OP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processS12InitOP(Q70ContextoEJIE contextoEjie, ActionErrors errors, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12LogotiposInitAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12LogotiposInitAction::processS12InitOP: INICIO");
		}


		BTransport transport = new BTransport();
		String language = Q70ListenerUtils.getLanguage(request);
		S12Idioma idioma = new S12Idioma();
		idioma.setIdIdioma(language);
		this.setSessionValueObjectInContext(idioma,"idioma");

		String urlFrom=request.getHeader("Referer");
		//String prueba = request.getRequestURI();
		contextoEjie.set("url",urlFrom);

		transport.setIdBackAction("LogotiposAction");
		transport.setIdSubBackAction(S12LogotiposInitAction.CONST_INIT_LOGOTIPOS);
		this.addTransport(transport);

		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12LogotiposInitAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12LogotiposInitAction::processS12InitOP: FIN ");
		}
	}

	/**
	 * Process s12 forward.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @return the action forward
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.S12BaseAction#processS12Forward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processS12Forward(Q70ContextoEJIE contextoEjie, ActionErrors errors, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if(!errors.isEmpty()){
			return mapping.findForward("error");
		}
		return mapping.findForward("ok");
	}

}
