/*
 * Created on 17-nov-2005
 *
 */
package s12.operacionespresentacion.logotipos;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import s12.operacionespresentacion.S12BaseAction;
import s12.valueObjects.comun.S12Idioma;
import s12.valueObjects.logotipos.S12SolicitudLogotipo;
import bilbofrmk.trasport.BTransport;
import bilbofrmk.util.BValidationUtil;
import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.presentacion.operacion.datos.Q70OPValidatorForm;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 *  
 *
 */
public class S12LogotiposAction extends S12BaseAction {

	/**
	 * Constante que indica el componente al que pertenece dicha clase. Es
	 * necesario para el uso del log de trazas.
	 */
	private static final String COMPONENTE = "LOGOTIPOS";

	/** The Constant CONST_ENVIAR_SOLICITUD. */
	private final static int CONST_ENVIAR_SOLICITUD = 2;

	/** The Constant MAX_LEN_APLICACIONES. */
	private static final int MAX_LEN_APLICACIONES = 4000;

	/** The Constant MAX_LEN_SUGERENCIAS. */
	private static final int MAX_LEN_SUGERENCIAS = 4000;

	/**
	 * Process s12 op.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.S12BaseAction#processS12OP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processS12OP(Q70ContextoEJIE contextoEjie,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {


		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12LogotiposAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12LogotiposAction::processS41OP: INICIO");
		}

		BTransport transport = new BTransport();
		Q70OPValidatorForm testForm = (Q70OPValidatorForm) form;
		S12SolicitudLogotipo solicitud = new S12SolicitudLogotipo();

		solicitud.setEntidad((String)testForm.get("entidad"));
		solicitud.setResponsable((String)testForm.get("responsable"));
		solicitud.setTelefono((String)testForm.get("telefono"));
		solicitud.setEmail((String)testForm.get("email"));
		solicitud.setAplicaciones((String)testForm.get("aplicaciones"));
		solicitud.setTamano((String)testForm.get("tamano"));
		solicitud.setFondo((String)testForm.get("fondo"));
		solicitud.setIdiomas((String)testForm.get("idiomas"));
		solicitud.setSugerencias((String)testForm.get("sugerencias"));

		/* B82: validacin previa de formato de email */
		BValidationUtil v = new BValidationUtil();
		if (solicitud.getEmail() == null || v.isEmpty((String)solicitud.getEmail()) || !v.isValidEmail(solicitud.getEmail())){
			errors.add("LOGOTIPOS",new ActionError("error.logotipos.email"));
		}

		/* B82: validacin de campos obligatorios */
		if (v.isEmpty(solicitud.getEntidad())){
			errors.add("LOGOTIPOS",new ActionError("error.logotipos.entidad"));
		}
		if (v.isEmpty(solicitud.getResponsable()) || v.isEmpty(solicitud.getTelefono()) || v.isEmpty(solicitud.getEmail())){
			errors.add("LOGOTIPOS",new ActionError("error.logotipos.responsable"));
		}
		if (v.isEmpty(solicitud.getAplicaciones())){
			errors.add("LOGOTIPOS",new ActionError("error.logotipos.aplicaciones"));
		}
		/* B82: validacin de tamaos mximos */
		if (solicitud.getAplicaciones()!=null && solicitud.getAplicaciones().trim().length() > S12LogotiposAction.MAX_LEN_APLICACIONES){
			errors.add("LOGOTIPOS",new ActionError("error.logotipos.aplicaciones.maxlength"));
		}
		if (solicitud.getSugerencias()!=null && solicitud.getSugerencias().trim().length() > S12LogotiposAction.MAX_LEN_SUGERENCIAS){
			errors.add("LOGOTIPOS",new ActionError("error.logotipos.sugerencias.maxlength"));
		}

		S12Idioma idioma  = (S12Idioma) this.getSessionValueObjectFromContext("idioma");
		transport.addParameter("idioma",idioma);
		transport.addParameter("solicitud",solicitud);
		transport.setIdBackAction("LogotiposAction");
		transport.setIdSubBackAction(S12LogotiposAction.CONST_ENVIAR_SOLICITUD);
		this.addTransport(transport);

		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12LogotiposAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12LogotiposAction::processS41OP: FIN");
		}
		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12LogotiposAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12LogotiposAction::processS41OP: FIN");
		}
	}

	/**
	 * Process s12 forward.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @return the action forward
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.S12BaseAction#processS12Forward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processS12Forward(Q70ContextoEJIE contextoEjie,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		if(!errors.isEmpty()){
			return mapping.findForward("error");
		}
		return mapping.findForward("bussiness");
	}

}
