/*
 * Created on 10-nov-2005
 */

package s12.operacionespresentacion.buscadores;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import s12.operacionespresentacion.S12BaseAction;
import s12.search.S12MunicipiosQuery;
import bilbofrmk.trasport.BTransport;
import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.presentacion.operacion.datos.Q70OPValidatorForm;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**

 *  
 */

public class S12CargarMunicipiosAction extends S12BaseAction {

	/**
	 * Constante que indica el componente al que pertenece dicha clase. Es
	 * necesario para el uso del log de trazas.
	 */
	private static final String COMPONENTE = "BUSCADORES";

	/**
	 * Process s12 op.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.S12BaseAction#processS12OP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processS12OP(Q70ContextoEJIE contextoEjie,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12CargarMunicipiosAction.COMPONENTE, Q70TraceLevel.DEBUG, " S12CargarMunicipiosAction ::processS12OP: INICIO");
		}

		Q70OPValidatorForm buscadorForm = (Q70OPValidatorForm) form;


//		Se prepara el transporte para sacar los municipios de una provincia en concreto

		S12MunicipiosQuery queryMunicipios = new S12MunicipiosQuery();

		String pagina = buscadorForm.get("pagina").toString();
		if (pagina.startsWith("agenda")){
			queryMunicipios.setCodProvincia(Long.parseLong(buscadorForm.get("provincia").toString()));
		}else if (pagina.startsWith("oferta")){
			queryMunicipios.setCodProvincia(Long.parseLong(buscadorForm.get("eventTerritory").toString()));
		}else{
			if ("".equals(buscadorForm.get("historicTerritoryCode").toString()))
			{
				queryMunicipios.setCodProvincia(-1);
			}else{
				queryMunicipios.setCodProvincia(Long.parseLong(buscadorForm.get("historicTerritoryCode").toString()));
			}
		}



		BTransport transport = new BTransport();
		transport.addParameter("query",queryMunicipios);
		transport.setIdBackAction("searchAction");
		this.addTransport(transport);

		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12CargarMunicipiosAction.COMPONENTE, Q70TraceLevel.DEBUG, " S12CargarMunicipiosAction ::processS12OP: FIN");
		}
	}



	/**
	 * Process s12 forward.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @return the action forward
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.S12BaseAction#processS12Forward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processS12Forward(Q70ContextoEJIE contextoEjie,

			ActionErrors errors, ActionMapping mapping, ActionForm form,

			HttpServletRequest request, HttpServletResponse response)

			throws Exception {
		return mapping.findForward("bussiness");
	}
}
