/*
 * Created on 10-nov-2005
 *
 */
package s12.operacionespresentacion.buscadores;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import bilbofrmk.trasport.BTransport;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
import s12.operacionespresentacion.S12BaseDisplayAction;
import s12.search.S12LocalidadesQuery;

/**
 *  
 *
 */
public class S12CargarLocalidadesDisplayAction extends S12BaseDisplayAction {

	/**
	 * Constante que indica el componente al que pertenece dicha clase. Es
	 * necesario para el uso del log de trazas.
	 */
	private static final String COMPONENTE = "BUSCADORES";

	/**
	 * Process s12 op.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.S12BaseDisplayAction#processS12OP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processS12OP(Q70ContextoEJIE contextoEjie,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12CargarLocalidadesDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12CargarLocalidadesDisplayAction::processS12OP: INICIO");
		}

		if(this.areBussinessErrors()){
			this.processBussinessErrors(errors);
		}else{

			BTransport transport = this.getTransport(0);
			S12LocalidadesQuery query = (S12LocalidadesQuery) transport.getParameter("query");
			query.setResultsLocale(this.getLocale(request));
			this.setQueryInContext(query,"S12LocalidadesQuery");
		}

		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12CargarLocalidadesDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12CargarLocalidadesDisplayAction::processS12OP: FIN");
		}
	}

	/**
	 * Process s12 forward.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @return the action forward
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.S12BaseDisplayAction#processS12Forward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processS12Forward(Q70ContextoEJIE contextoEjie,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {


		return mapping.findForward("ok");
	}

}
