/*
 * Created on 10-nov-2005
 */
package s12.operacionespresentacion.buscadores;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import s12.operacionespresentacion.S12BaseAction;
import s12.search.S12LocalidadesQuery;
import s12.search.S12MunicipiosQuery;
import s12.search.record.S12MunicipioRecord;
import bilbofrmk.trasport.BTransport;
import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.presentacion.operacion.datos.Q70OPValidatorForm;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 *  
 */
public class S12CargarLocalidadesAction extends S12BaseAction {

	/**
	 * Constante que indica el componente al que pertenece dicha clase. Es
	 * necesario para el uso del log de trazas.
	 */
	private static final String COMPONENTE = "BUSCADORES";

	/**
	 * Process s12 op.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.S12BaseAction#processS12OP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processS12OP(Q70ContextoEJIE contextoEjie,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12CargarLocalidadesAction.COMPONENTE, Q70TraceLevel.DEBUG, " S12CargarMunicipiosAction ::processS12OP: INICIO");
		}

		Q70OPValidatorForm postalForm = (Q70OPValidatorForm) form;

//		Se prepara el transporte para sacar los municipios de una provincia en concreto
		S12LocalidadesQuery queryLocalidades = new S12LocalidadesQuery();
		queryLocalidades.setCodProvincia(Long.parseLong(postalForm.get("historicTerritoryCode").toString()));
		S12MunicipiosQuery queryMunicipios = (S12MunicipiosQuery) this.getQueryFromContext("S12MunicipiosQuery");
		S12MunicipioRecord rcdMunicipio = (S12MunicipioRecord) queryMunicipios.getRecordById(postalForm.get("municipalityCode").toString());
		queryLocalidades.setCodMunicipio(Long.parseLong(rcdMunicipio.getCodMunicipio()));
		BTransport transport = new BTransport();
		transport.addParameter("query",queryLocalidades);
		transport.setIdBackAction("searchAction");

		this.addTransport(transport);


		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12CargarLocalidadesAction.COMPONENTE, Q70TraceLevel.DEBUG, " S12CargarMunicipiosAction ::processS12OP: FIN");
		}
	}

	/**
	 * Process s12 forward.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @return the action forward
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.S12BaseAction#processS12Forward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processS12Forward(Q70ContextoEJIE contextoEjie,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		return mapping.findForward("bussiness");
	}

}
