package s12.operacionespresentacion.buscadores;

//import java.util.HashMap;
//import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import s12.constantes.S12Constantes;
import s12.operacionespresentacion.comun.S12BaseAppInitAction;
import s12.util.S12AppConfig;
//import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;
//import com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils;
import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.presentacion.operacion.datos.Q70OPValidatorForm;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 *  
 *
 */
public class S12BuscarApiAction extends S12BaseAppInitAction {

	/**
	 * Constante que indica el componente al que pertenece dicha clase. Es
	 * necesario para el uso del log de trazas.
	 */
	private static final String COMPONENTE = "BUSCADORES";

	private String url;

	/**
	 * Process s12 init op.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.comun.S12BaseAppInitAction#processS12InitOP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processS12InitOP(Q70ContextoEJIE contextoEjie,
		ActionErrors errors, ActionMapping mapping, ActionForm form,
		HttpServletRequest request, HttpServletResponse response)
		throws Exception {

		try {
			this.url="";
//			R01MQueryObject qry = new R01MQueryObject();

			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12BuscarApiAction.COMPONENTE, Q70TraceLevel.DEBUG, "Despues del R01MQueryObject qry = new R01MQueryObject()");
			}

			String searchType = "";
			if(request.getParameter("searchType")!=null){
				searchType = (String)request.getParameter("searchType");
			}

			/****/
			StringBuffer urlBuffer = new StringBuffer();
			/****/

			Q70OPValidatorForm buscadorForm = (Q70OPValidatorForm) form;
//			qry.addContentCluster("euskadi");
//
//			qry.addContentFamily("turismo");

			/****/
			urlBuffer.append("tC:euskadi;tF:turismo;");
			/****/

//			qry.setPublishedItemsOnly(true);
//			qry.setReturnDocuments(true);
//			qry.setReturnDataFiles(true);

			/**
			 * Recoger el formulario que le envia la jsp
			 * Recoger todos los parametros del buscadorForm.get(""), mirar los que llegan != null
			 * Conviene crear una clase ce constantes para los parametros del formulario
			 * Todos los parametros del formulario estan en struts-buscadoresAPI.xml (puede faltar alguno que cantara, templateType)
			 * Si hay que aadir alguno hacerlo a ultima hora ya que GEREMUA no se actualiza hasta el dia siguiente a la maana
			 */
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12BuscarApiAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscarApiAction Inicio *******************************");
			}

			//TEMPLATE TYPE
			String lodgingType = "";
			String sectorType = "";
			String templateType = "";
			if((String)buscadorForm.get(S12Constantes.SF_TEMPLATE_TYPE) != null && !buscadorForm.get(S12Constantes.SF_TEMPLATE_TYPE).toString().equals("")){

				//si tiene subtipo lo dividimos
				if (((String)buscadorForm.get(S12Constantes.SF_TEMPLATE_TYPE)).indexOf(";") != -1) {
					templateType = ((String)buscadorForm.get(S12Constantes.SF_TEMPLATE_TYPE)).split(";")[0];

					//subtipo de alojamiento
					if (templateType.equals(S12Constantes.TIPORECURSOALOJAMIENTOS)){
						lodgingType = ((String)buscadorForm.get(S12Constantes.SF_TEMPLATE_TYPE)).split(";")[1];
					//subtipo de empresas relacionadas
					}else if (templateType.equals(S12Constantes.TIPORECURSOEMPRESAS_RELACIONADAS)){
						sectorType = ((String)buscadorForm.get(S12Constantes.SF_TEMPLATE_TYPE)).split(";")[1];
					}
				}else{
					templateType = (String)buscadorForm.get(S12Constantes.SF_TEMPLATE_TYPE);
				}
//				qry.addMetaData(S12Constantes.SF_TEMPLATE_TYPE,R01MSearchEngineConstants.EQUALS_OPERATOR,templateType);

				//CONTENT_TYPE
//				qry.addContentType(S12Constantes.getContentType(templateType));

				/****/
				urlBuffer.append("tT:").append(S12Constantes.getContentType(templateType)).append(";");
				/****/

				if (Q70Factoria.getTraza().isTraceActive()) {
					Q70Factoria.getTraza().trace(S12BuscarApiAction.COMPONENTE, Q70TraceLevel.DEBUG, "CONTENT TYPE: "+S12Constantes.getContentType(templateType));
				}
			}

			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12BuscarApiAction.COMPONENTE, Q70TraceLevel.DEBUG, "PASADO TEMPLATE TYPE");
			}

			/****/
			urlBuffer.append("m:documentPublicationInfo.EQ.1,");
			if((String)buscadorForm.get(S12Constantes.SF_LANGUAGE_APLICATION) != null && !buscadorForm.get(S12Constantes.SF_LANGUAGE_APLICATION).toString().equals("")){
				urlBuffer.append("documentLanguage.EQ.").append((String)buscadorForm.get(S12Constantes.SF_LANGUAGE_APLICATION)).append(",");
			}
			/****/

			//LODGING_TYPE
			if(!"".equals(lodgingType) && !"1".equals(searchType)){
				StringBuffer lodging = new StringBuffer();
				if("8".equals(lodgingType)){
					lodging.append("(K").append(R01MSearchEngineConstants.IN_VALUES_SEPARATOR).append("X)");
					lodgingType = lodging.toString();
//					qry.addMetaData(S12Constantes.SF_LODGING_TYPE, R01MSearchEngineConstants.IN_OPERATOR, lodgingType);
				}else{
//					qry.addMetaData(S12Constantes.SF_LODGING_TYPE,R01MSearchEngineConstants.EQUALS_OPERATOR,lodgingType);
				}
			}

			/****/
			if(null!=templateType && !"".equals(templateType)){
				urlBuffer.append("templateType.EQ.").append(templateType).append(",");
				if(!"".equals(lodgingType) && !"1".equals(searchType)){
					if(lodgingType.startsWith("(")){
						urlBuffer.append("lodgingType.IN.").append(lodgingType).append(",");
					}else{
						urlBuffer.append("lodgingType.EQ.").append(lodgingType).append(",");
					}
				}else if(!"".equals(sectorType)){
					urlBuffer.append("sectorType.EQ.").append(sectorType).append(",");
				}
			}


			/****/

			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12BuscarApiAction.COMPONENTE, Q70TraceLevel.DEBUG, "PASADO LODGING TYPE");
			}


			//HISTORIC_TERRITORY_CODE
			if((String)buscadorForm.get(S12Constantes.SF_HISTORIC_TERRITORY_CODE) != null
					&& !buscadorForm.get(S12Constantes.SF_HISTORIC_TERRITORY_CODE).toString().equals(""))
			{
//				qry.addMetaData(S12Constantes.SF_HISTORIC_TERRITORY_CODE,R01MSearchEngineConstants.LIKE_OPERATOR,(String)buscadorForm.get(S12Constantes.SF_HISTORIC_TERRITORY_CODE));
				urlBuffer.append("historicTerritoryCode.LIKE.").append((String)buscadorForm.get(S12Constantes.SF_HISTORIC_TERRITORY_CODE)).append(",");
			}

			//MUNICIPALITY_CODE
			if((String)buscadorForm.get(S12Constantes.SF_MUNICIPALITY_CODE) != null
					&& !buscadorForm.get(S12Constantes.SF_MUNICIPALITY_CODE).toString().equals(""))
			{
//				qry.addMetaData(S12Constantes.SF_MUNICIPALITY_CODE,R01MSearchEngineConstants.LIKE_OPERATOR,(String)buscadorForm.get(S12Constantes.SF_MUNICIPALITY_CODE));
				urlBuffer.append("municipalityCode.LIKE.").append((String)buscadorForm.get(S12Constantes.SF_MUNICIPALITY_CODE)).append(",");
			}

			//LOCALITY_CODE
			if((String)buscadorForm.get(S12Constantes.SF_LOCALITY_CODE) != null
					&& !buscadorForm.get(S12Constantes.SF_LOCALITY_CODE).toString().equals("")){
//				qry.addMetaData(S12Constantes.SF_LOCALITY_CODE,R01MSearchEngineConstants.LIKE_OPERATOR,(String)buscadorForm.get(S12Constantes.SF_LOCALITY_CODE));
				urlBuffer.append("localityCode.LIKE.").append((String)buscadorForm.get(S12Constantes.SF_LOCALITY_CODE)).append(",");
			}


			/****/
			urlBuffer.append("qualityQ.LIKE.1;o:documentName.ASC;pp:r01PageSize.10");
//			System.out.println("URL: " + url.toString());
			/****/

			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12BuscarApiAction.COMPONENTE, Q70TraceLevel.DEBUG, "PASADO CODIGO LOCALIDAD");
			}


//		 	Map presentationProperties = new HashMap();
//	    presentationProperties.put(R01MQueryObject.PRESENTATION_PAGE_SIZE,"10");
//	    qry.setPresentationProperties(presentationProperties);


			/**
			 * ii
			 * realiza la busqueda
			 */
			//this.url= R01MSearchEngineUtils.encodeQueryObjectInURL(qry);
	    this.url=urlBuffer.toString();

//			if (Q70Factoria.getTraza().isTraceActive()) {
//				Q70Factoria.getTraza().trace(S12BuscarApiAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscarApiAction qry :"+ qry.toString());
//			}


	    if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12BuscarApiAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscarApiAction URL :"+ this.url);
			}


		}catch (Exception ex) {

			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12BuscarApiAction.COMPONENTE, Q70TraceLevel.ERROR, "ERROR MENS: **********************"+ex.getMessage());
				Q70Factoria.getTraza().trace(S12BuscarApiAction.COMPONENTE, Q70TraceLevel.ERROR, "ERROR CAUSE: **********************"+ex.getCause());
			}
		}

	}

	/**
	 * Process s12 forward.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @return the action forward
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.S12BaseAction#processS12Forward
	 * (es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors,
	 * org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm,
	 * javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processS12Forward(Q70ContextoEJIE contextoEjie,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		/**
		 * ii
		 * Hay que conseguir una url que lleva a la pagina de resultados del portal dependiendo del buscador
		 * que sea.
		 * Ahora saca:
		 * http://www.turismoa.euskadi.ejiedes.net/r01hProxyWar/r01hProxyInter_difu_apps1/s12WebAppWar/buscadoresAPI/i:r01mds011504021203485e4097e3eb4b50ffdf7f1;sS:ejsun28;sR:ejsun28.euskadi;sA:ejsun28.euskadi.turismo;sW:ejsun28.euskadi.turismo.ws11_comun;tC:euskadi;tF:turismo;m:historicTerritoryCode.LIKE.48;
		 * Creo que tiene que salir la siguiente url:
		 * http://www.turismoa.euskadi.net/s11-16875x/es?i:r01mds011502a688ff4aafe036e242a444c046fd8;sS:ejsun28;sR:ejsun28.euskadi;sA:ejsun28.euskadi.turismo;sW:ejsun28.euskadi.turismo.ws11_comun;tC:euskadi;tF:turismo;m:historicTerritoryCode.LIKE.48;
		 * Con esta sentencia te devuelve la pgina de resultados a la que tiene que ir.
		 * String pagina = buscadorForm.get("pagina").toString(); (/s11-16875x/)
		 *
		 */
		Q70OPValidatorForm buscadorForm = (Q70OPValidatorForm) form;
		String pagina = buscadorForm.get("pagina").toString();
		String numPagina=S12AppConfig.getInstance().getValue(pagina);

		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12BuscarApiAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscarApiAction-processS12Forward: Pagina: "+ numPagina);
		}
		String idioma=(String)buscadorForm.get(S12Constantes.SF_LANGUAGE_APLICATION);
		String urlPathPortal = "";
		if ("qCalidad".equals(pagina)){
			urlPathPortal = S12AppConfig.getInstance().getValue("URL_PATH_PORTAL_INDUSTRIA");
		}else{
			urlPathPortal = S12AppConfig.getInstance().getValue("URL_PATH_PORTAL");
		}

		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12BuscarApiAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscarApiAction-processS12Forward: urlPathPortal: "+ urlPathPortal);
		}
		String urlCompleta=urlPathPortal+numPagina+"/"+idioma+"/"+S12Constantes.QUERY_PARAM+this.url;


		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12BuscarApiAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscarApiAction-processS12Forward: urlCompletaBuena: "+ urlCompleta);
		}

		ActionForward newFwd = new ActionForward("external",urlCompleta, true, true);

		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12BuscarApiAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscarApiAction-processS12Forward: urlCompletaSimulada: "+ urlCompleta);
		}
		return newFwd;
	}

	/**
	 * Gets the url.
	 *
	 * @return the url
	 */
	public String getUrl() {
		return this.url;
	}

	/**
	 * Sets the url.
	 *
	 * @param url the new url
	 */
	public void setUrl(String url) {
		this.url = url;
	}
}
