/*
 * Created on 02-nov-2005
 *
 */

package s12.operacionespresentacion.buscadores;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import s12.operacionespresentacion.comun.S12BaseAppInitAction;
import s12.search.S12BuscadorIndustriaQuery;
import s12.search.S12MunicipiosQuery;
import s12.search.S12ProvinciasQuery;
import bilbofrmk.trasport.BTransport;
import bilbofrmk.util.BValidationUtil;
import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.presentacion.operacion.datos.Q70OPValidatorForm;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 *  
 *
 */

public class S12BuscadoresInitAction extends S12BaseAppInitAction{

	/**
	 * Constante que indica el componente al que pertenece dicha clase. Es
	 * necesario para el uso del log de trazas.
	 */
	private static final String COMPONENTE = "BUSCADORES";

	/**
	 * Process s12 init op.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.S12BaseAction#processS12OP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processS12InitOP(Q70ContextoEJIE contextoEjie, ActionErrors errors, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12BuscadoresInitAction.COMPONENTE, Q70TraceLevel.DEBUG, " S12BuscadoresInitAction ::processS12OP: INICIO");
		}

		//Se prepara el transporte para sacar los territorios historicos que existen

		S12ProvinciasQuery queryProvincias = new S12ProvinciasQuery();

		BTransport transport = new BTransport();
		transport.addParameter("query",queryProvincias);
		transport.setIdBackAction("searchAction");
		transport.setIdTransport("provincias");
		this.addTransport(transport);



		Q70OPValidatorForm buscadorForm = (Q70OPValidatorForm) form;

		String pagina = buscadorForm.get("pagina").toString();
		String codProvincia="";
		/*if (pagina.startsWith("agenda")){
			codProvincia = (String)buscadorForm.get("provincia");
		}/*else if (pagina.startsWith("oferta")){
			codProvincia = (String)buscadorForm.get("eventTerritory");
		}else{*/
			codProvincia = (String)buscadorForm.get("historicTerritoryCode");
		//}

		BValidationUtil validator = new BValidationUtil();

		if(!validator.isEmpty(codProvincia)) {

			//Se prepara el transporte para sacar los municipios que existen

			S12MunicipiosQuery queryMunicipios = new S12MunicipiosQuery();

			/*if (pagina.startsWith("agenda")){
				queryMunicipios.setCodProvincia(Long.parseLong((String)buscadorForm.get("provincia")));
			}/*else if (pagina.startsWith("oferta")){
				queryMunicipios.setCodProvincia(Long.parseLong((String)buscadorForm.get("eventTerritory")));
			}else{*/
				queryMunicipios.setCodProvincia(Long.parseLong((String)buscadorForm.get("historicTerritoryCode")));
			//}

			transport = new BTransport();
			transport.addParameter("query",queryMunicipios);
			transport.setIdBackAction("searchAction");
			transport.setIdTransport("municipios");

			this.addTransport(transport);
		}

		//para las busqueda de recursos con la Q de Calidad
		if ("qCalidad".equals(pagina)){
			S12BuscadorIndustriaQuery queryQCalidad = new S12BuscadorIndustriaQuery();
			queryQCalidad.setLang(request.getParameter("lang"));
			transport = new BTransport();
			transport.addParameter("query",queryQCalidad);
			transport.setIdBackAction("searchAction");
			transport.setIdTransport("qCalidad");
			this.addTransport(transport);
		}
		//S12Idioma idioma=(S12Idioma)getSessionValueObjectFromContext("idioma");
		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12BuscadoresInitAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscadoresInitAction::processS12OP: FIN ");
		}
	}



	/**
	 * Process s12 forward.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @return the action forward
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.S12BaseAction#processS12Forward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processS12Forward(Q70ContextoEJIE contextoEjie, ActionErrors errors, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		return mapping.findForward("bussiness");
	}
}
