/*

 * Created on 04-nov-2005
 *
 */

package s12.operacionespresentacion.buscadores;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import bilbofrmk.trasport.BTransport;
import bilbofrmk.util.BValidationUtil;
import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.presentacion.operacion.datos.Q70OPValidatorForm;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
import s12.operacionespresentacion.S12BaseDisplayAction;
import s12.search.S12BuscadorIndustriaQuery;
import s12.search.S12MunicipiosQuery;
import s12.search.S12LocalidadesQuery;
import s12.search.S12ProvinciasQuery;
import s12.search.record.S12ProvinciaRecord;
import s12.valueObjects.comun.S12Idioma;

/**

 *  

 *

 */

public class S12BuscadoresDisplayAction extends S12BaseDisplayAction {

	/**
	 * Constante que indica el componente al que pertenece dicha clase. Es
	 * necesario para el uso del log de trazas.
	 */
	private static final String COMPONENTE = "BUSCADORES";

	/**
	 * Process s12 op.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.S12BaseDisplayAction#processS12OP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processS12OP(Q70ContextoEJIE contextoEjie,

			ActionErrors errors, ActionMapping mapping, ActionForm form,

			HttpServletRequest request, HttpServletResponse response)

			throws Exception {

		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12BuscadoresDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscadoresInitDisplayAction::processS12OP:*********************************");
			Q70Factoria.getTraza().trace(S12BuscadoresDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscadoresInitDisplayAction::processS12OP:  *************INICIO***********");
			Q70Factoria.getTraza().trace(S12BuscadoresDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscadoresInitDisplayAction::processS12OP:*********************************");
		}
		Q70OPValidatorForm buscadorForm = (Q70OPValidatorForm) form;


		S12Idioma idioma=(S12Idioma)this.getSessionValueObjectFromContext("idioma");
		String idiomaActual = idioma.getIdIdioma();

		buscadorForm.set("languageAplication",idiomaActual);

		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12BuscadoresDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscadoresInitDisplayAction::processS12OP:*********************************");
			Q70Factoria.getTraza().trace(S12BuscadoresDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscadoresInitDisplayAction::processS12OP:  SE HA FIJADO EL IDOMA: " + idiomaActual);
			Q70Factoria.getTraza().trace(S12BuscadoresDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscadoresInitDisplayAction::processS12OP:*********************************");
		}

		if(this.areBussinessErrors()){


			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12BuscadoresDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscadoresInitDisplayAction::processS12OP:*********************************");
				Q70Factoria.getTraza().trace(S12BuscadoresDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscadoresInitDisplayAction::processS12OP: HAY ERRORES ");
			}
			this.processBussinessErrors(errors);

			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12BuscadoresDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscadoresInitDisplayAction::processS12OP:*********************************");
			}
		}else{


			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12BuscadoresDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscadoresInitDisplayAction::processS12OP:*********************************");
				Q70Factoria.getTraza().trace(S12BuscadoresDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscadoresInitDisplayAction::processS12OP:  NO HAY ERRORES");
				Q70Factoria.getTraza().trace(S12BuscadoresDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscadoresInitDisplayAction::processS12OP:*********************************");
			}
//			Recogemos las provincias de la bd

			BTransport transport = this.getTransport("provincias");

			S12ProvinciasQuery queryProvincias = (S12ProvinciasQuery) transport.getParameter("query");

			queryProvincias.setResultsLocale(this.getLocale(request));

			this.setQueryInContext(queryProvincias,"S12ProvinciasQuery");

			String codProvincia="";
			String pagina = buscadorForm.get("pagina").toString();

			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12BuscadoresDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscadoresInitDisplayAction::processS12OP:*********************************");
				Q70Factoria.getTraza().trace(S12BuscadoresDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscadoresInitDisplayAction::processS12OP: PAGINA DEL BUSCADOR: "+ pagina);
				Q70Factoria.getTraza().trace(S12BuscadoresDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscadoresInitDisplayAction::processS12OP:*********************************");
			}
			/*if (pagina.startsWith("agenda")){
				codProvincia = (String)buscadorForm.get("provincia");
			}/*else if (pagina.startsWith("oferta")){
				codProvincia = (String)buscadorForm.get("eventTerritory");
			}else{*/
				codProvincia = (String)buscadorForm.get("historicTerritoryCode");
			//}

			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12BuscadoresDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscadoresInitDisplayAction::processS12OP:*********************************");
				Q70Factoria.getTraza().trace(S12BuscadoresDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscadoresInitDisplayAction::processS12OP:  codProvincia: "+codProvincia);
				Q70Factoria.getTraza().trace(S12BuscadoresDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscadoresInitDisplayAction::processS12OP:*********************************");
			}
			//String codProvincia = (String)buscadorForm.get("historicTerritoryCode");



			BValidationUtil validator = new BValidationUtil();



			if(!validator.isEmpty(codProvincia)) {

				S12ProvinciaRecord rcdProv = (S12ProvinciaRecord)queryProvincias.getRecordById(codProvincia);
				/*if (pagina.startsWith("agenda")){
					buscadorForm.set("provincia",rcdProv.getNomProvincia());
				}/*else if (pagina.startsWith("oferta")){
					buscadorForm.set("eventTerritory",rcdProv.getNomProvincia());
				}else{*/
					buscadorForm.set("historicTerritoryName",rcdProv.getNomProvincia());
				//}
				//buscadorForm.set("historicTerritoryName",rcdProv.getNomProvincia());

			}





			S12MunicipiosQuery queryMunicipios = new S12MunicipiosQuery();

			if(this.getTransport("municipios") != null){

				if (Q70Factoria.getTraza().isTraceActive()) {
					Q70Factoria.getTraza().trace(S12BuscadoresDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscadoresInitDisplayAction::processS12OP:*********************************");
					Q70Factoria.getTraza().trace(S12BuscadoresDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscadoresInitDisplayAction::processS12OP:  Cargando los municipos");
					Q70Factoria.getTraza().trace(S12BuscadoresDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscadoresInitDisplayAction::processS12OP:*********************************");
				}
				BTransport municipiosTransport = this.getTransport("municipios");

				queryMunicipios = (S12MunicipiosQuery)municipiosTransport.getParameter("query");

				queryMunicipios.setResultsLocale(this.getLocale(request));

			}

			this.setQueryInContext(queryMunicipios,"S12MunicipiosQuery");



//			creamos una query localidades vacia

			S12LocalidadesQuery queryLocalidades = new S12LocalidadesQuery();

			this.setQueryInContext(queryLocalidades,"S12LocalidadesQuery");



			//para cuando accedemos a la pgina de recursos con Q de Calidad
			S12BuscadorIndustriaQuery queryQCalidad = new S12BuscadorIndustriaQuery();
			if(this.getTransport("qCalidad") != null){
				BTransport qCalidadTransport = this.getTransport("qCalidad");
				queryQCalidad = (S12BuscadorIndustriaQuery)qCalidadTransport.getParameter("query");
				queryQCalidad.setResultsLocale(this.getLocale(request));
			}
			this.setQueryInContext(queryQCalidad, "S12QCalidadQuery");



			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12BuscadoresDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscadoresInitDisplayAction::processS12OP:*********************************");
				Q70Factoria.getTraza().trace(S12BuscadoresDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscadoresInitDisplayAction::processS12OP:  FINAL DEL ELSE");
				Q70Factoria.getTraza().trace(S12BuscadoresDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscadoresInitDisplayAction::processS12OP:*********************************");
			}
		}

		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12BuscadoresDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscadoresInitDisplayAction::processS12OP:*********************************");
			Q70Factoria.getTraza().trace(S12BuscadoresDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscadoresInitDisplayAction::processS12OP:  FIN");
			Q70Factoria.getTraza().trace(S12BuscadoresDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12BuscadoresInitDisplayAction::processS12OP:*********************************");
		}


	}



	/**
	 * Process s12 forward.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @return the action forward
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.S12BaseDisplayAction#processS12Forward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processS12Forward(Q70ContextoEJIE contextoEjie,

			ActionErrors errors, ActionMapping mapping, ActionForm form,

			HttpServletRequest request, HttpServletResponse response)

			throws Exception {
		return mapping.findForward("ok");
	}
}
