/*
 * Created on 09-dic-2005
 *
 */
package s12.operacionespresentacion.adminLogotipos;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import s12.operacionespresentacion.S12BaseAction;
import s12.valueObjects.logotipos.S12SolicitudLogotipo;
import bilbofrmk.trasport.BTransport;
import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.presentacion.operacion.datos.Q70OPValidatorForm;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 *  
 *
 */
public class S12AdminVerSolicitudAction extends S12BaseAction {

	/**
	 * Constante que indica el componente al que pertenece dicha clase. Es
	 * necesario para el uso del log de trazas.
	 */
	private static final String COMPONENTE = "LOGOTIPOS";

	/**
	 * Process s12 op.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.S12BaseAction#processS12OP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processS12OP(Q70ContextoEJIE contextoEjie,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12AdminVerSolicitudAction.COMPONENTE, Q70TraceLevel.DEBUG, " S12AdminVerSolicitudAction ::processS12OP: INICIO");
		}

		BTransport transport = new BTransport();
		Q70OPValidatorForm formLogotipos = (Q70OPValidatorForm) form;
		S12SolicitudLogotipo solicitud = new S12SolicitudLogotipo();
		solicitud.setId(new Integer(formLogotipos.get("codSolicitud").toString()).longValue());
		transport.addParameter("solicitud",solicitud);
		transport.setIdBackAction("AdminLogotiposAction");
		transport.setIdSubBackAction(2);
		this.addTransport(transport);

		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12AdminVerSolicitudAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12AdminVerSolicitudAction::processS12OP: FIN ");
		}
	}

	/**
	 * Process s12 forward.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @return the action forward
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.S12BaseAction#processS12Forward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processS12Forward(Q70ContextoEJIE contextoEjie,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		return mapping.findForward("bussiness");
	}

}
