/*
 * Created on 04-nov-2005
 */
package s12.operacionespresentacion.adminLogotipos;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import s12.operacionespresentacion.S12BaseDisplayAction;
import s12.search.S12LogotiposQuery;
import bilbofrmk.trasport.BTransport;
import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 *  
 *
 */
public class S12AdminLogotiposInitDisplayAction extends S12BaseDisplayAction {

	/**
	 * Constante que indica el componente al que pertenece dicha clase. Es
	 * necesario para el uso del log de trazas.
	 */
	private static final String COMPONENTE = "LOGOTIPOS";

	/**
	 * Process s12 op.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.S12BaseDisplayAction#processS12OP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processS12OP(Q70ContextoEJIE contextoEjie,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12AdminLogotiposInitDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S121AdminLogotiposInitDisplayAction::processS12OP:  INICIO");
		}

		//Q70OPValidatorForm testForm = (Q70OPValidatorForm) form;
		BTransport backTransport = this.getTransport(0);

		S12LogotiposQuery logotiposQuery = (S12LogotiposQuery)backTransport.getParameter("queryLogotipos");
		this.setQueryInContext(logotiposQuery,"logotiposJSP");

		if(this.areBussinessErrors()){
			this.processBussinessErrors(errors);
		}else{
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12AdminLogotiposInitDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12AdminLogotiposInitDisplayAction::processS12OP:  FIN");
			}
		}
	}

	/**
	 * Process s12 forward.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @return the action forward
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.S12BaseDisplayAction#processS12Forward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processS12Forward(Q70ContextoEJIE contextoEjie,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		if(!errors.isEmpty()){
			return mapping.findForward("error");
		}
		return mapping.findForward("ok");
	}

}
