/*
 * Created on 15-mar-2006
 *
 */
package s12.operacionespresentacion;

import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import s12.operacionespresentacion.S12BaseLoadSubSelectAction;
import s12.search.S12LocalidadesQuery;
import s12.search.S12MunicipiosQuery;
import s12.search.record.S12MunicipioRecord;

/**
 *  
 *
 */
public class S12LoadGeoSelectsAction extends S12BaseLoadSubSelectAction {

	/**
	 * Do sub select.
	 *
	 * @param request the request
	 *
	 * @throws Exception the exception
	 *
	 * @see s41.operacionespresentacion.S41BaseLoadSubSelectAction#doSubSelect(javax.servlet.http.HttpServletRequest)
	 */
	protected void doSubSelect(HttpServletRequest request) throws Exception {

		if (this.getStrQuery().compareTo("QMunicipios")==0){
			S12MunicipiosQuery municipiosQuery = new S12MunicipiosQuery();
			long idProvincia = Long.parseLong(this.getCriteria());
			municipiosQuery.setCodProvincia(idProvincia);
			this.addQuery(municipiosQuery);
		}

		if (this.getStrQuery().compareTo("QLocalidades")==0){
			S12LocalidadesQuery localidadesQuery = new S12LocalidadesQuery();
			StringTokenizer tk = new StringTokenizer(this.getCriteria(),"|");

			long idProvincia = Long.parseLong(tk.nextToken());
			String codMunicipio="";
			if (tk.hasMoreTokens()){
			 codMunicipio = tk.nextToken();
			}
			 if ((codMunicipio == null) ||(codMunicipio.equals(""))){
				codMunicipio="0";
			 }

			localidadesQuery.setCodProvincia(idProvincia);
			
			if ("0".equals(codMunicipio)){
				localidadesQuery.setCodMunicipio(0);
			}else{
				S12MunicipiosQuery queryMunicipios = (S12MunicipiosQuery) this.getQueryFromContext("S12MunicipiosQuery");

				S12MunicipioRecord rcdMunicipio = (S12MunicipioRecord) queryMunicipios.getRecordById(codMunicipio);

				localidadesQuery.setCodMunicipio(Long.parseLong(rcdMunicipio.getCodMunicipio()));
			}
			this.addQuery(localidadesQuery);
		}

	}

}
