/*
 * Created on 15-mar-2006
 *
 */
package s12.operacionespresentacion;

import java.util.ArrayList;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import bilbofrmk.search.BBaseQuery;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 *  
 *
 */
public abstract class S12BaseLoadSubSelectDisplayAction extends S12BaseDisplayAction {

  private String criteria;
  private String strForm;
  private String strQuery;
  private ArrayList queries;
  private ArrayList selectIds;
  private ArrayList selects2Clean;
  private ArrayList items2SetValue;
  private ArrayList values4Items;


	/**
	 * Process s12 op.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @throws Exception the exception
	 *
	 * @see s41.operacionespresentacion.S41BaseDisplayAction#processS41OP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processS12OP(Q70ContextoEJIE contextoEjie,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

    this.selectIds = new ArrayList();
    this.queries = new ArrayList();
    this.selects2Clean = new ArrayList();
    this.items2SetValue = new ArrayList();
    this.values4Items = new ArrayList();
    this.strQuery = request.getParameter("queryName");
    this.criteria = request.getParameter("criteria");
    this.strForm = request.getParameter("form");

    this.doSubSelect(request,form);

    request.setAttribute("selects2Clean",this.selects2Clean);
    request.setAttribute("queries",this.queries);
    request.setAttribute("selectIds",this.selectIds);
    request.setAttribute("itemsIds",this.items2SetValue);
    request.setAttribute("itemsValues",this.values4Items);

	}

	/**
	 * Process s12 forward.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @return the action forward
	 *
	 * @throws Exception the exception
	 *
	 * @see s41.operacionespresentacion.S41BaseDisplayAction#processS41Forward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
  protected ActionForward processS12Forward(Q70ContextoEJIE contextoEjie,
      ActionErrors errors, ActionMapping mapping, ActionForm form,
      HttpServletRequest request, HttpServletResponse response)
      throws Exception {
		
    return mapping.findForward("SubSelecct.load.success");
  }

  /**
   * Adds the item2 set value.
   *
   * @param idItem the id item
   */
  protected void addItem2SetValue(String idItem){
    this.items2SetValue.add(idItem);
  }

  /**
   * Adds the value4 item.
   *
   * @param value the value
   */
  protected void addValue4Item(String value){
    this.values4Items.add(value);
  }

  /**
   * Adds the query.
   *
   * @param query the query
   */
  protected void addQuery(BBaseQuery query){
    this.queries.add(query);
  }

  /**
   * Adds the select2 clean.
   *
   * @param id the id
   */
  protected void addSelect2Clean(String id){
    this.selects2Clean.add(id);
  }

  /**
   * Adds the select id.
   *
   * @param id the id
   */
  protected void addSelectId(String id){
    this.selectIds.add(id);
  }

  /**
   * Do sub select.
   *
   * @param request the request
   * @param form the form
   *
   * @throws Exception the exception
   */
  protected abstract void doSubSelect(HttpServletRequest request, ActionForm form)throws Exception;

  /**
   * Gets the criteria.
   *
   * @return the criteria
   */
  public String getCriteria() {
    return this.criteria;
  }

  /**
   * Sets the criteria.
   *
   * @param criteria the new criteria
   */
  public void setCriteria(String criteria) {
    this.criteria = criteria;
  }

  /**
   * Gets the str form.
   *
   * @return the str form
   */
  public String getStrForm() {
    return this.strForm;
  }

  /**
   * Sets the str form.
   *
   * @param strForm the new str form
   */
  public void setStrForm(String strForm) {
    this.strForm = strForm;
  }

  /**
   * Gets the str query.
   *
   * @return the str query
   */
  public String getStrQuery() {
    return this.strQuery;
  }

  /**
   * Sets the str query.
   *
   * @param strQuery the new str query
   */
  public void setStrQuery(String strQuery) {
    this.strQuery = strQuery;
  }

  /**
   * Gets the queries.
   *
   * @return the queries
   */
  public ArrayList getQueries() {
    return this.queries;
  }

  /**
   * Sets the queries.
   *
   * @param queries the new queries
   */
  public void setQueries(ArrayList queries) {
    this.queries = queries;
  }

  /**
   * Gets the select ids.
   *
   * @return the select ids
   */
  public ArrayList getSelectIds() {
    return this.selectIds;
  }

  /**
   * Sets the select ids.
   *
   * @param selectIds the new select ids
   */
  public void setSelectIds(ArrayList selectIds) {
    this.selectIds = selectIds;
  }

  /**
   * Gets the selects2 clean.
   *
   * @return the selects2 clean
   */
  public ArrayList getSelects2Clean() {
    return this.selects2Clean;
  }

  /**
   * Sets the selects2 clean.
   *
   * @param selects2Clean the new selects2 clean
   */
  public void setSelects2Clean(ArrayList selects2Clean) {
    this.selects2Clean = selects2Clean;
  }

  /**
   * Gets the items2 set value.
   *
   * @return the items2 set value
   */
  public ArrayList getItems2SetValue() {
    return this.items2SetValue;
  }

  /**
   * Sets the items2 set value.
   *
   * @param items2SetValue the new items2 set value
   */
  public void setItems2SetValue(ArrayList items2SetValue) {
    this.items2SetValue = items2SetValue;
  }

  /**
   * Gets the values4 items.
   *
   * @return the values4 items
   */
  public ArrayList getValues4Items() {
    return this.values4Items;
  }

  /**
   * Sets the values4 items.
   *
   * @param values4Items the new values4 items
   */
  public void setValues4Items(ArrayList values4Items) {
    this.values4Items = values4Items;
  }

}
