/*
 * Created on 15-mar-2006
 *
 */
package s12.operacionespresentacion;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import bilbofrmk.search.BBaseQuery;
import bilbofrmk.trasport.BTransport;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * The Class S12BaseLoadSubSelectAction.
 *
 *  
 *
 */
public abstract class S12BaseLoadSubSelectAction extends S12BaseAction {
	private String criteria;
	private String strForm;
	private String strQuery;


	/**
	 * Process s12 op.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @throws Exception the exception
	 *
	 * @see s41.operacionespresentacion.S41BaseAction#processS41OP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processS12OP(Q70ContextoEJIE contextoEjie,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		this.strQuery = request.getParameter("queryName");
		this.criteria = request.getParameter("criteria");

		if (this.criteria.equals("")){
			this.criteria="0";
		}
		this.strForm = request.getParameter("form");

		this.doSubSelect(request);
	}

	/**
	 * Process s12 forward.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @return the action forward
	 *
	 * @throws Exception the exception
	 *
	 * @see s41.operacionespresentacion.S41BaseAction#processS41Forward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processS12Forward(Q70ContextoEJIE contextoEjie,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		return mapping.findForward("bussiness");
	}

	/**
	 * Do sub select.
	 *
	 * @param request the request
	 *
	 * @throws Exception the exception
	 */
	protected abstract void doSubSelect(HttpServletRequest request)throws Exception;

	/**
	 * Adds the query.
	 *
	 * @param query the query
	 */
	protected void addQuery(BBaseQuery query){

		BTransport transport = new BTransport();
		transport.addParameter("query",query);
		transport.setIdBackAction("searchAction");
		this.addTransport(transport);

	}

	/**
	 * Gets the criteria.
	 *
	 * @return the criteria
	 */
	public String getCriteria() {
		return this.criteria;
	}

	/**
	 * Sets the criteria.
	 *
	 * @param criteria the new criteria
	 */
	public void setCriteria(String criteria) {
		this.criteria = criteria;
	}

	/**
	 * Gets the str form.
	 *
	 * @return the str form
	 */
	public String getStrForm() {
		return this.strForm;
	}

	/**
	 * Sets the str form.
	 *
	 * @param strForm the new str form
	 */
	public void setStrForm(String strForm) {
		this.strForm = strForm;
	}

	/**
	 * Gets the str query.
	 *
	 * @return the str query
	 */
	public String getStrQuery() {
		return this.strQuery;
	}

	/**
	 * Sets the str query.
	 *
	 * @param strQuery the new str query
	 */
	public void setStrQuery(String strQuery) {
		this.strQuery = strQuery;
	}
}
