/*
 * Created on 08-jul-2005
 *
 */
package s12.operacionespresentacion;

import java.util.HashMap;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.Globals;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import bilbofrmk.search.BBaseQuery;
import bilbofrmk.trasport.BBussinessPack;
import bilbofrmk.trasport.BTransport;
import bilbofrmk.valueObjects.BBaseValueObject;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * The Class S12BaseAction.
 *
 *  
 */
public abstract class S12BaseAction extends Q70ActionPasoOP {

	/** The b pack. */
	private BBussinessPack bPack;

	/** The value objects. */
	private HashMap valueObjects;

	/** The session value objects. */
	private HashMap sessionValueObjects;

	/**
	 * Adds the transport.
	 *
	 * @param transport the transport
	 */
	protected void addTransport(BTransport transport){
		this.bPack.addTransport(transport);
	}

	/**
	 * Sets the value object in context.
	 *
	 * @param valueObject the value object
	 * @param name the name
	 */
	protected void setValueObjectInContext(BBaseValueObject valueObject, String name){ // NO_UCD
		this.valueObjects.put(name,valueObject);
	}

	/**
	 * Gets the value object from context.
	 *
	 * @param name the name
	 *
	 * @return the value object from context
	 */
	protected BBaseValueObject getValueObjectFromContext(String name){ // NO_UCD
		return (BBaseValueObject) this.valueObjects.get(name);
	}


	/**
	 * Sets the session value object in context.
	 *
	 * @param valueObject the value object
	 * @param name the name
	 */
	protected void setSessionValueObjectInContext(BBaseValueObject valueObject, String name){
		this.sessionValueObjects.put(name,valueObject);
	}

	/**
	 * Gets the session value object from context.
	 *
	 * @param name the name
	 *
	 * @return the session value object from context
	 */
	protected BBaseValueObject getSessionValueObjectFromContext(String name){
		return (BBaseValueObject) this.sessionValueObjects.get(name);
	}


	/**
	 * Sets the query in context.
	 *
	 * @param query the query
	 * @param name the name
	 */
	protected void setQueryInContext(BBaseQuery query, String name){ // NO_UCD
		this.valueObjects.put(name,query);
	}

	/**
	 * Gets the query from context.
	 *
	 * @param name the name
	 *
	 * @return the query from context
	 */
	protected BBaseQuery getQueryFromContext(String name){
		return (BBaseQuery) this.valueObjects.get(name);
	}

	/**
	 * Gets the locale.
	 *
	 * @param request the request
	 *
	 * @return the locale
	 *
	 * @see org.apache.struts.action.Action#getLocale(javax.servlet.http.HttpServletRequest)
	 */
	protected Locale getLocale(HttpServletRequest request){
		return (Locale) request.getSession().getAttribute(Globals.LOCALE_KEY);
	}


	/**
	 * Process op.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @throws Exception the exception
	 *
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processOP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processOP(Q70ContextoEJIE contextoEjie, ActionErrors errors,
			ActionMapping mapping, ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {

		this.bPack = new BBussinessPack();
		this.valueObjects = (HashMap) contextoEjie.get("valueObjects");
		this.sessionValueObjects = (HashMap) contextoEjie.get("sessionValueObjects");
		if(this.valueObjects==null){
			this.valueObjects = new HashMap();
		}
		if(this.sessionValueObjects==null){
			 this.sessionValueObjects = new HashMap();
		}
		this.processS12OP(contextoEjie,errors,mapping,form,request,response);

		HashMap facadeDataPack = new HashMap();

		facadeDataPack.put("BBussinessPack",this.bPack);
		contextoEjie.set("facadeDataPack",facadeDataPack);

		contextoEjie.set("valueObjects",this.valueObjects);
		contextoEjie.set("sessionValueObjects",this.sessionValueObjects);
	}

	/**
	 * Process s12 op.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @throws Exception the exception
	 */
	abstract protected void processS12OP(Q70ContextoEJIE contextoEjie,ActionErrors errors,
			ActionMapping mapping, ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception;

	/**
	 * Process forward.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @return the action forward
	 *
	 * @throws Exception the exception
	 *
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processForward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processForward(Q70ContextoEJIE contextoEjie, ActionErrors errors,
			ActionMapping mapping, ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		if(!errors.isEmpty()) {
			return mapping.getInputForward();
		}
		return this.processS12Forward(contextoEjie, errors, mapping, form, request, response);
	}


	/**
	 * Process s12 forward.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @return the action forward
	 *
	 * @throws Exception the exception
	 */
	abstract protected ActionForward processS12Forward(Q70ContextoEJIE contextoEjie,
			ActionErrors errors, ActionMapping mapping, ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception;

	/**
	 * Gets the b pack.
	 *
	 * @return the b pack
	 */
	public BBussinessPack getBPack() {
		return this.bPack;
	}

	/**
	 * Sets the b pack.
	 *
	 * @param pack the new b pack
	 */
	public void setBPack(BBussinessPack pack) {
		this.bPack = pack;
	}

	/**
	 * Gets the value objects.
	 *
	 * @return the value objects
	 */
	public HashMap getValueObjects() {
		return this.valueObjects;
	}

	/**
	 * Sets the value objects.
	 *
	 * @param valueObjects the new value objects
	 */
	public void setValueObjects(HashMap valueObjects) {
		this.valueObjects = valueObjects;
	}

	/**
	 * Gets the session value objects.
	 *
	 * @return the session value objects
	 */
	public HashMap getSessionValueObjects() {
		return this.sessionValueObjects;
	}

	/**
	 * Sets the session value objects.
	 *
	 * @param sessionValueObjects the new session value objects
	 */
	public void setSessionValueObjects(HashMap sessionValueObjects) {
		this.sessionValueObjects = sessionValueObjects;
	}
}
