/*
 * Created on 28-jun-2005
 *
 */
package s12.operacionesinternas;

import java.util.HashMap;
import java.util.Locale;
import s12.util.S12JDBCConnector;
import bilbofrmk.context.BContext;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInterna;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;


/**
 *  
 */
public class S12Manager extends Q70OperacionInterna {

	/**
	 * Pre process mapping entrada.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param arg1 the arg1
	 * @param arg2 the arg2
	 *
	 * @throws Exception the exception
	 *
	 * @see es.ejie.frmk.negocio.operacioninterna.Q70OperacionInterna#preProcessMappingEntrada(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean, es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors)
	 */
	protected void preProcessMappingEntrada(Q70ContextoEJIE contextoEjie,
			Q70OperacionInternaConfigBean arg1, Q70OperacionInternaErrors arg2)
			throws Exception {

		BContext bContext = new BContext();
		bContext.setUrlContextProvider(Q70ListenerUtils.getApplicationProperty("URL_CONTEXT_PROVIDER"));
		bContext.setWlInitialContextFactory(Q70ListenerUtils.getApplicationProperty("INITIAL_CONTEXT_FACTORY"));
		bContext.setDataSourceName(Q70ListenerUtils.getApplicationProperty("S12_JNDI_DATASOURCE"));

		S12JDBCConnector conectorJDBC = new S12JDBCConnector();

		bContext.setLookupBConnectionObject(conectorJDBC);

		bContext.setContextoBD(false);


		bContext.setUserLogin("S12");

		Locale loc;
		String idioma = (String)contextoEjie.get("idiomaCompartido");
		if("es".equals(idioma)){
			loc = new Locale("ES","es");
		}else{
			loc = new Locale("ES","eu");
		}
		bContext.setUserLocale(loc);


		HashMap facadeDataPack = (HashMap) contextoEjie.get("facadeDataPack");
		facadeDataPack.put("BContexto",bContext);
		contextoEjie.set("facadeDataPack",facadeDataPack);
	}

	/**
	 * Post process mapping salida.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param arg1 the arg1
	 *
	 * @throws Exception the exception
	 *
	 * @see es.ejie.frmk.negocio.operacioninterna.Q70OperacionInterna#postProcessMappingSalida(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors)
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contextoEjie,
			Q70OperacionInternaErrors arg1) throws Exception {
		super.postProcessMappingSalida(contextoEjie, arg1);
	}
}
