package s12.search;

import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import es.ejie.frmk.negocio.adaptadorinvocacion.Q70FactoriaEJBHome;

import bilbofrmk.context.BIContext;
import bilbofrmk.exceptions.BSearchException;
import bilbofrmk.search.BBaseQuery;
import s12.s12SearchService.S12SearchServiceHome;
import s12.s12SearchService.S12SearchServiceObject;

/**
 *  
 *
 */
public class S12SearchSrv {
	
	/**
	 * Instantiates a new s12 search srv.
	 */
	private S12SearchSrv() {

	}

	/**
	 * Do search.
	 *
	 * @param appContex the app contex
	 * @param query the query
	 *
	 * @return the b base query
	 *
	 * @throws BSearchException the b search exception
	 */
	public static BBaseQuery doSearch(BIContext appContex,BBaseQuery query) throws BSearchException{
		try {
			S12SearchServiceHome serviceHome  = (S12SearchServiceHome)Q70FactoriaEJBHome.getSingleton().getHome("s12.S12SearchServiceEJB");
			S12SearchServiceObject service = serviceHome.create();
			return service.doQuery(appContex,query);

		} catch (NamingException e) {
			throw new BSearchException("Error de nombrado del servicio de busquedas",e);
		} catch (ClassCastException e) {
			return S12SearchSrv.classicCall(appContex,query);
		} catch (CreateException e) {
			throw new BSearchException("Error creando del servicio de busquedas",e);
		} catch (RemoteException e) {
			throw new BSearchException("Error del servicio de busquedas",e.getCause());
		}
	}

	/**
	 * Classic call.
	 *
	 * @param appContex the app contex
	 * @param query the query
	 *
	 * @return the b base query
	 *
	 * @throws BSearchException the b search exception
	 */
	private static BBaseQuery classicCall(BIContext appContex,BBaseQuery query) throws BSearchException{

		try {
			Context context = new InitialContext();
			S12SearchServiceHome serviceHome  = (S12SearchServiceHome)context.lookup("s12.S12SearchServiceEJB");

			S12SearchServiceObject service = serviceHome.create();

			return service.doQuery(appContex,query);
		} catch (NamingException e) {
			throw new BSearchException("Error de nombrado del servicio de busquedas",e);
		} catch (ClassCastException e) {
			throw new BSearchException("Error de creacin del servicio de busquedas",e);
		} catch (CreateException e) {
			throw new BSearchException("Error creando del servicio de busquedas",e);
		} catch (RemoteException e) {
			throw new BSearchException("Error del servicio de busquedas",e.getCause());
		} catch (Throwable t) {
			throw new BSearchException("Error del servicio de busquedas",t.getCause());
		}
	}

}
