/*
 * Created on 03-nov-2005
 *
 */
package s12.search;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import s12.search.record.S12ProvinciaRecord;

import bilbofrmk.exceptions.BSearchException;
import bilbofrmk.search.BBaseQuerySolver;

/**
 *  
 *
 */
public class S12ProvinciasQuerySolver extends BBaseQuerySolver{ // NO_UCD

	private static final int SIZE_STRINGBUFFER = 115;

	/**
	 *  
	 * Instantiates a new s12 provincias query solver.
	 */
	public S12ProvinciasQuerySolver(){

	}

	/**
	 * Gets the sql.
	 *
	 * @param parameters the parameters
	 *
	 * @return the sql
	 *
	 * @see bilbofrmk.search.BBaseQuerySolver#getSql(java.util.ArrayList)
	 */
	protected String getSql(ArrayList parameters) {
		S12ProvinciasQuery query = (S12ProvinciasQuery) this.mQuery;

		boolean todasProv = query.isTodas();
		StringBuffer sql = new StringBuffer(S12ProvinciasQuerySolver.SIZE_STRINGBUFFER);

		sql.append("SELECT CODPROVINC, NOMPROVINC, NOMPROVINCE  FROM PROVINCIAS");
		if (!todasProv){
			sql.append(" WHERE CODPROVINC IN (1,20,48)");
		}
		sql.append(" ORDER BY NOMPROVINC ASC");
		return sql.toString();

	}

	/**
	 * Process resul set.
	 *
	 * @param rs the rs
	 *
	 * @throws SQLException the SQL exception
	 * @throws BSearchException the b search exception
	 *
	 * @see bilbofrmk.search.BBaseQuerySolver#processResulSet(java.sql.ResultSet)
	 */
	protected void processResulSet(ResultSet rs) throws SQLException, BSearchException {
		S12ProvinciaRecord record;
		while(rs.next()) {
			record = new S12ProvinciaRecord();
			record.setCodProvincia(rs.getLong("CODPROVINC"));
			record.setNomProvinciaCas(rs.getString("NOMPROVINC"));
			record.setNomProvinciaEus(rs.getString("NOMPROVINCE"));
			this.mQuery.getResults().add(record);
		}

	}

}
