/*
 * Created on 02/02/2009
 *
 */
package s12.search;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import s12.search.record.S12PaisesTraduccionesRecord;
import bilbofrmk.exceptions.BSearchException;
import bilbofrmk.search.BBaseQuerySolver;

/**
 *  
 * The Class S12PaisesTraduccionesQuerySolver.
 */
public class S12PaisesTraduccionesQuerySolver  extends BBaseQuerySolver{ // NO_UCD

	private static final int SIZE_STRINGBUFFER = 70;

	/**
	 * Gets the sql.
	 *
	 * @param parameters the parameters
	 *
	 * @return the sql
	 *
	 * @see bilbofrmk.search.BBaseQuerySolver#getSql(java.util.ArrayList)
	 */
	protected String getSql(ArrayList parameters) {
		StringBuffer sql = new StringBuffer(S12PaisesTraduccionesQuerySolver.SIZE_STRINGBUFFER);
//		sql.append("Select codpais, nompais, nompaise from FCA.FCA03T00 ");
		sql.append("Select codpais, nompais, nompaiseu, nompaisen, nompaisfr, nompaisde from PAISES ");
		sql.append("Order by nompais");
		return sql.toString();
	}

	/**
	 * Process resul set.
	 *
	 * @param rs the rs
	 *
	 * @throws SQLException the SQL exception
	 * @throws BSearchException the b search exception
	 *
	 * @see bilbofrmk.search.BBaseQuerySolver#processResulSet(java.sql.ResultSet)
	 */
	protected void processResulSet(ResultSet rs) throws SQLException,
			BSearchException {
		S12PaisesTraduccionesRecord paisRecord;
		while(rs.next()){
			paisRecord = new S12PaisesTraduccionesRecord();
			paisRecord.setCodPais(rs.getInt("CODPAIS"));
			paisRecord.setNomPais(rs.getString("NOMPAIS"));
			paisRecord.setNomPaisEu(rs.getString("NOMPAISEU"));
			paisRecord.setNomPaisEn(rs.getString("NOMPAISEN"));
			paisRecord.setNomPaisFr(rs.getString("NOMPAISFR"));
			paisRecord.setNomPaisDe(rs.getString("NOMPAISDE"));
			this.mQuery.getResults().add(paisRecord);
		}

	}

}
