/*
 * Created on 31-oct-2005
 *
 */
package s12.search;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import s12.search.record.S12NewsletterRecord;
import bilbofrmk.exceptions.BSearchException;
import bilbofrmk.search.BBaseQuerySolver;

/**
 *  
 *
 */
public class S12NewsletterQuerySolver extends BBaseQuerySolver { // NO_UCD

	private static final int SIZE_STRINGBUFFER = 95;

	/**
	 * @param parameters the parameters
	 *
	 * @return the sql
	 *
	 * @see bilbofrmk.search.BBaseQuerySolver#getSql(java.util.ArrayList)
	 */
	protected String getSql(ArrayList parameters) {
		S12NewsletterQuery query = (S12NewsletterQuery) this.mQuery;

		StringBuffer sql = new StringBuffer(S12NewsletterQuerySolver.SIZE_STRINGBUFFER);
		sql.append("SELECT NOMBRE, APELLIDOS, EMAIL, IDIOMA FROM S12_FORMULARIO WHERE TIPO = 'N'");

		if (query.getIdioma()!=null){
			sql.append(" AND IDIOMA = ? ");
			parameters.add(query.getIdioma());
		}
		return sql.toString();
	}


	/**
	 * @param rs the rs
	 *
	 * @throws SQLException the SQL exception
	 * @throws BSearchException the b search exception
	 *
	 * @see bilbofrmk.search.BBaseQuerySolver#processResulSet(java.sql.ResultSet)
	 */
	protected void processResulSet(ResultSet rs) throws SQLException,BSearchException {
		S12NewsletterRecord record;
		while(rs.next()) {
			record = new S12NewsletterRecord();
			record.setNombre(rs.getString("NOMBRE"));
			record.setApellidos(rs.getString("APELLIDOS"));
			record.setEmail(rs.getString("EMAIL"));
			record.setIdioma(rs.getString("IDIOMA"));

			this.mQuery.getResults().add(record);
		}

	}

}
