/*
 * Created on 31-oct-2005
 *
 */
package s12.search;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import s12.search.record.S12MunicipioRecord;
import bilbofrmk.exceptions.BSearchException;
import bilbofrmk.search.BBaseQuerySolver;

/**
 *  
 */
public class S12MunicipiosQuerySolver extends BBaseQuerySolver {

	private static final int SIZE_STRINGBUFFER = 105;

	/**
	 * Instantiates a new s12 municipios query solver.
	 */
	public S12MunicipiosQuerySolver(){

	}

	/**
	 * @param parameters the parameters
	 *
	 * @return the sql
	 *
	 * @see bilbofrmk.search.BBaseQuerySolver#getSql(java.util.ArrayList)
	 */
	protected String getSql(ArrayList parameters) {
		StringBuffer strWhere= new StringBuffer(S12MunicipiosQuerySolver.SIZE_STRINGBUFFER);
		S12MunicipiosQuery query = (S12MunicipiosQuery) this.mQuery;
		StringBuffer sql = new StringBuffer(S12MunicipiosQuerySolver.SIZE_STRINGBUFFER);
		sql.append("SELECT CODPROVINC, CODMUNICIP, NOMMUNICIP, NOMMUNICIPE FROM MUNICIPIOS");

		strWhere.append(" WHERE ");
		strWhere.append(" CODPROVINC = ? ");
		parameters.add(Long.toString(query.getCodProvincia()));


		if (strWhere.length() > 0) {
			sql.append(strWhere);
		}
		sql.append(" ORDER BY NOMMUNICIP,NOMMUNICIPE");
		return sql.toString();
	}

	/**
	 * @param rs the rs
	 *
	 * @throws SQLException the SQL exception
	 * @throws BSearchException the b search exception
	 *
	 * @see bilbofrmk.search.BBaseQuerySolver#processResulSet(java.sql.ResultSet)
	 */
	protected void processResulSet(ResultSet rs) throws SQLException,
			BSearchException {
		S12MunicipioRecord record;
		while(rs.next()) {
			record = new S12MunicipioRecord();
			record.setCodProvincia(rs.getLong("CODPROVINC"));
			record.setCodMunicipio(rs.getLong("CODMUNICIP"));
			record.setNomMunicipioCas(rs.getString("NOMMUNICIP"));
			record.setNomMunicipioEus(rs.getString("NOMMUNICIPE"));

			this.mQuery.getResults().add(record);
		}

	}

}
