/*
 * Created on 31-oct-2005
 *
 */
package s12.search;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import s12.search.record.S12LogotiposRecord;
import bilbofrmk.exceptions.BSearchException;
import bilbofrmk.search.BBaseQuerySolver;

/**
 *  
 *
 */
public class S12LogotiposQuerySolver extends BBaseQuerySolver { // NO_UCD

	private static final int SIZE_STRINGBUFFER = 95;

	/**
	 * @param parameters the parameters
	 *
	 * @return the sql
	 *
	 * @see bilbofrmk.search.BBaseQuerySolver#getSql(java.util.ArrayList)
	 */
	protected String getSql(ArrayList parameters) {
		//S12LogotiposQuery query = (S12LogotiposQuery) this.mQuery;

		StringBuffer sql = new StringBuffer(S12LogotiposQuerySolver.SIZE_STRINGBUFFER);
		sql.append("SELECT CODSOLICITUD, FECHAENVIO, ENTIDAD, RESPONSABLE, TELEFONO, EMAIL, ");
		sql.append("APLICACIONES, TAMANO, FONDO, IDIOMAS, SUGERENCIAS ");
		sql.append("FROM S12_SOLICITUD_LOGOTIPO ORDER BY FECHAENVIO DESC");

		return sql.toString();
	}


	/**
	 * @param rs the rs
	 *
	 * @throws SQLException the SQL exception
	 * @throws BSearchException the b search exception
	 *
	 * @see bilbofrmk.search.BBaseQuerySolver#processResulSet(java.sql.ResultSet)
	 */
	protected void processResulSet(ResultSet rs) throws SQLException,BSearchException {
		S12LogotiposRecord record;
		while(rs.next()) {
			record = new S12LogotiposRecord();
			record.setId(String.valueOf(rs.getLong("CODSOLICITUD")));
			record.setFechaEnvio(rs.getDate("FECHAENVIO"));
			record.setEntidad(rs.getString("ENTIDAD"));
			record.setResponsable(rs.getString("RESPONSABLE"));
			record.setTelefono(rs.getString("TELEFONO"));
			record.setEmail(rs.getString("EMAIL"));
			record.setAplicaciones(rs.getString("APLICACIONES"));
			record.setTamano(rs.getString("TAMANO"));
			record.setFondo(rs.getString("FONDO"));
			record.setIdiomas(rs.getString("IDIOMAS"));
			record.setSugerencias(rs.getString("SUGERENCIAS"));
			this.mQuery.getResults().add(record);
		}
	}

}
