/*
 * Created on 31-oct-2005
 */

package s12.search;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import s12.search.record.S12LocalidadRecord;
import bilbofrmk.exceptions.BSearchException;
import bilbofrmk.search.BBaseQuerySolver;

/**
 *  
 */
public class S12LocalidadesQuerySolver extends BBaseQuerySolver {

	private static final int SIZE_STRINGBUFFER = 115;

	/**
	 * Instantiates a new s12 localidades query solver.
	 */
	public S12LocalidadesQuerySolver(){

	}

	/**
	 * @param parameters the parameters
	 *
	 * @return the sql
	 *
	 * @see bilbofrmk.search.BBaseQuerySolver#getSql(java.util.ArrayList)
	 */
	protected String getSql(ArrayList parameters) {
		StringBuffer strWhere= new StringBuffer(S12LocalidadesQuerySolver.SIZE_STRINGBUFFER);
		S12LocalidadesQuery query = (S12LocalidadesQuery) this.mQuery;
		StringBuffer sql = new StringBuffer(S12LocalidadesQuerySolver.SIZE_STRINGBUFFER);
		sql.append("SELECT CODLOCALID, CODPROVINC, CODMUNICIP, NOMLOCALID, NOMLOCALIDE FROM LOCALIDADES");

		if (query.getCodProvincia()!=-1)
		{
			strWhere.append(" WHERE ");
			strWhere.append(" CODPROVINC = ? ");
			parameters.add(Long.toString(query.getCodProvincia()));


			if (query.getCodMunicipio()!=-1)
			{
				strWhere.append(" AND CODMUNICIP = ? ");
				parameters.add(Long.toString(query.getCodMunicipio()));
			}
		}

		if (strWhere.length() > 0) {
			sql.append(strWhere);
		}
		sql.append(" ORDER BY NOMLOCALID,NOMLOCALIDE");

		return sql.toString();
	}

	/**
	 * @param rs the rs
	 *
	 * @throws SQLException the SQL exception
	 * @throws BSearchException the b search exception
	 *
	 * @see bilbofrmk.search.BBaseQuerySolver#processResulSet(java.sql.ResultSet)
	 */
	protected void processResulSet(ResultSet rs) throws SQLException,
			BSearchException {

		S12LocalidadRecord record;

		while(rs.next()) {
			record = new S12LocalidadRecord();
			record.setCodLocalidad(rs.getLong("CODLOCALID"));
			record.setCodProvincia(rs.getLong("CODPROVINC"));
			record.setCodMunicipio(rs.getLong("CODMUNICIP"));
			record.setNomLocalidadCas(rs.getString("NOMLOCALID"));
			record.setNomLocalidadEus(rs.getString("NOMLOCALIDE"));
			this.mQuery.getResults().add(record);
		}
	}
}

