/*
 * Created on 20-abr-2009
 *
 */
package s12.search;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import s12.constantes.S12Constantes;
import s12.search.record.S12BuscadorIndustriaRecord;

import bilbofrmk.exceptions.BSearchException;
import bilbofrmk.search.BBaseQuerySolver;

/**
 *  
 *
 */
public class S12BuscadorIndustriaQuerySolver extends BBaseQuerySolver { // NO_UCD

	private static final int SIZE_STRINGBUFFER = 110;

	/**
	 * (non-Javadoc).
	 *
	 * @param parameters the parameters
	 *
	 * @return the sql
	 *
	 * @see bilbofrmk.search.BBaseQuerySolver#getSql(java.util.ArrayList)
	 */
	protected String getSql(ArrayList parameters) {
		StringBuffer sql = new StringBuffer(S12BuscadorIndustriaQuerySolver.SIZE_STRINGBUFFER);
		String qCalidad = "38";

		sql.append("SELECT T1.COTIPREC ");
		sql.append("FROM TIPO_RECURSO T1, SRV_TREC T2 ");
		sql.append("WHERE T1.COTIPREC = T2.COTIPREC ");
		sql.append("AND T2.COSERVICIO = '" + qCalidad + "'" );

		return sql.toString();
	}

	/**
	 * @param rs the rs
	 *
	 * @throws SQLException the SQL exception
	 * @throws BSearchException the b search exception
	 *
	 * @see bilbofrmk.search.BBaseQuerySolver#processResulSet(java.sql.ResultSet)
	 */
	protected void processResulSet(ResultSet rs) throws SQLException,
			BSearchException {
		S12BuscadorIndustriaRecord record;
		while(rs.next()) {
			record = new S12BuscadorIndustriaRecord();
			record.setCoTipRec(rs.getString("COTIPREC"));
			if("es".equals(((S12BuscadorIndustriaQuery)mQuery).getLang())){
				record.setNomTipRec((String)S12Constantes.getRecursoTypeMapEs().get(rs.getString("COTIPREC")));
			}else{
				record.setNomTipRec((String)S12Constantes.getRecursoTypeMapEu().get(rs.getString("COTIPREC")));
			}
			this.mQuery.getResults().add(record);
		}
	}
}