package s12.report;

import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.naming.NamingException;
import es.ejie.frmk.negocio.adaptadorinvocacion.Q70FactoriaEJBHome;
import s12.s12ReportService.S12ReportServiceHome;
import s12.s12ReportService.S12ReportServiceObject;
import bilbofrmk.context.BIContext;
import bilbofrmk.exceptions.BReportException;
import bilbofrmk.reports.BBaseReport;

/**
 * The Class S12ReportSrv.
 *
 *  
 *
 */
public class S12ReportSrv {

	/**
	 * Do report.
	 *
	 * @param appContex the app contex
	 * @param report the report
	 *
	 * @return the b base report
	 *
	 * @throws BReportException the b report exception
	 */
	public static BBaseReport doReport(BIContext appContex,BBaseReport report) throws BReportException {
		try {
			S12ReportServiceHome serviceHome  = (S12ReportServiceHome)Q70FactoriaEJBHome.getSingleton().getHome("s12.S12ReportServiceEJB");
			S12ReportServiceObject service = serviceHome.create();
			BBaseReport backReport = service.doReport(appContex,report);

			return backReport;
		} catch (NamingException e) {
			throw new BReportException("Error de nombrado del servicio de busquedas",e);
		} catch (ClassCastException e) {
			throw new BReportException("Error de creacin del servicio de busquedas",e);
		} catch (CreateException e) {
			throw new BReportException("Error creando del servicio de busquedas",e);
		} catch (RemoteException e) {
			throw new BReportException("Error del servicio de busquedas",e.getCause());
		}
	}

	/**
	 * Instantiates a new s12 report srv.
	 */
	private S12ReportSrv() {
	}
}
