/*
 * Created on 17-nov-2005
 *
 */
package s12.report;

import java.util.ArrayList;

import s12.valueObjects.logotipos.S12LogotiposMail;
import s12.valueObjects.logotipos.S12SolicitudLogotipo;
import bilbofrmk.exceptions.BReportException;
import bilbofrmk.reports.BBaseReportSolver;
import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesException;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;

/**
 *  
 *
 */
public class S12LogotiposReportSolver extends BBaseReportSolver { // NO_UCD

	/**
	 * Constante que indica el componente al que pertenece dicha clase. Es
	 * necesario para el uso del log de trazas.
	 */
	private static final String COMPONENTE = "LOGOTIPOS";

	private static final int SIZE_STRINGBUFFER = 965;

	/**
	 * Do xml report.
	 *
	 * @throws BReportException
	 *           the b report exception
	 *
	 * @see bilbofrmk.reports.BBaseReportSolver#doXMLReport()
	 */
	protected void doXMLReport() throws BReportException {
		S12LogotiposReport lReport = (S12LogotiposReport) report;
		S12LogotiposMail lMail = lReport.getLogotiposMail();
		S12SolicitudLogotipo solicitud = lReport.getSolicitud();
		StringBuffer xml = new StringBuffer(S12LogotiposReportSolver.SIZE_STRINGBUFFER);

		// Linea de cabecera
		xml.append(xmlCab);

		// record
		xml.append("<record name =\"" + Long.toString(solicitud.getId()) + "\" type=\"content\">");

		// Inicio Idioma
		xml.append("<item name=\"s12_idioma\"><value/></item>");

		xml.append("<item name=\"pathEstatico\"><value>");
		// Q70ListenerUtils.getApplicationProperty("URL_HOST")+
		xml.append(this.xmlData(Q70ListenerUtils.getApplicationProperty("ALIAS_ESTATICO")));
		xml.append("</value></item>");

		// Inicio Datos Generales
		xml.append("<item name=\"datos_generales\"><value>");

		// Inicio Cabecera Logos Izquierda y Derecha
		xml.append("<item name=\"s12_imagenCabeceraIzq\"><value>");

		String cabeceraIzq = "";
		try {
			cabeceraIzq = Q70GestorMensajesi18n.getSingleton().getMessage("s12Postales", "postales.cabecera1", lReport.getIdioma().getIdIdioma(), null);
			// RequestUtils.message(pageContext, "s41Recursos", Globals.LOCALE_KEY,
			// "localidad.territorioHistorico");
		} catch (Q70GestorMensajesException e) {

			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12LogotiposReportSolver.COMPONENTE, Q70TraceLevel.DEBUG, "S12EnviarPostalDisplayAction::process12OP:  INICIO");
			}
			// Falta por capturar esta incidencia
		}

		xml.append(this.xmlData(cabeceraIzq));
		xml.append("</value></item>");


		// Inicio Cabecera
		xml.append("<item name=\"s12_imagenCabeceraDer\"><value>");

		String cabeceraDer = "";
		try {
			cabeceraDer = Q70GestorMensajesi18n.getSingleton().getMessage("s12Postales", "postales.cabecera2", lReport.getIdioma().getIdIdioma(), null);
			// RequestUtils.message(pageContext, "s41Recursos", Globals.LOCALE_KEY,
			// "localidad.territorioHistorico");
		} catch (Q70GestorMensajesException e) {

			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12LogotiposReportSolver.COMPONENTE, Q70TraceLevel.DEBUG, "S12EnviarPostalDisplayAction::process12OP:  INICIO");
			}
			// Falta por capturar esta incidencia
		}

		xml.append(cabeceraDer);
		xml.append("</value></item>");

		// Inicio Alt Cabecera
		xml.append("<item name=\"s12_altCabecera\"><value/></item>");

		// Inicio Remitente
		xml.append("<item name=\"s12_nomRemitente\"><value>");

		String recibido = "";
		ArrayList<String> arrayPostal = new ArrayList<String>();
		arrayPostal.add(lMail.getFromSolicitud());
		try {
			recibido = Q70GestorMensajesi18n.getSingleton().getMessage("s12Postales", "postal.recibido", lReport.getIdioma().getIdIdioma(), arrayPostal.toArray());
			// RequestUtils.message(pageContext, "s41Recursos", Globals.LOCALE_KEY,
			// "localidad.territorioHistorico");
		} catch (Q70GestorMensajesException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12LogotiposReportSolver.COMPONENTE, Q70TraceLevel.DEBUG, "S12EnviarPostalDisplayAction::process12OP:  INICIO");
			}
		}

		xml.append(this.xmlData(recibido));
		xml.append("</value></item>");

		/* b82
		// Inicio Imagen Postal
		xml.append("<item name=\"s12_imagenPostal\"><value>");
		xml.append(this.xmlData(pathSolicitud + "?nombrePostal=" + solicitud.getUrlPostal() + "&R01HNoPortal=true"));
		xml.append("</value></item>");

		// Inicio Alt Imagen Postal
		xml.append("<item name=\"s12_altPostal\"><value>");
		xml.append(this.xmlData(solicitud.getNombrePostal()));
		xml.append("</value></item>");

		// Inicio Titulo Postal
		xml.append("<item name=\"s12_tituloPostal\"><value>");
		xml.append(this.xmlData(postal.getNombrePostal()));
		xml.append("</value></item>");

		// Inicio Descripcion Postal
		xml.append("<item name=\"s12_descripcionPostal\"><value>");
		xml.append(this.xmlData(postal.getDescripcionPostal()));
		xml.append("</value></item>");

		// Inicio Mensaje
		xml.append("<item name=\"s12_saludo\"><value>");

		String saludo = "";
		ArrayList paramSaludo = new ArrayList();
		paramSaludo.add(lMail.getToNombrePostal());

		try {
			saludo = Q70GestorMensajesi18n.getSingleton().getMessage("s12Postales", "postal.saludo", lReport.getIdioma().getIdIdioma(), paramSaludo.toArray());
			// RequestUtils.message(pageContext, "s41Recursos", Globals.LOCALE_KEY,
			// "localidad.territorioHistorico");
		} catch (Q70GestorMensajesException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12LogotiposReportSolver.COMPONENTE, Q70TraceLevel.DEBUG, "S12EnviarPostalDisplayAction::process12OP:  INICIO");
			}
		}

		xml.append(this.xmlData(saludo));
		xml.append("</value></item>");
		*/

		// Inicio Mensaje
		//B82: recojo los textos de campos
		String msgCabeceraMensaje = "";
		String msgEntidad = "";
		String msgResponsable = "";
		String msgTelefono = "";
		String msgEmail = "";
		String msgAplicaciones = "";
		String msgTamano = "";
		String msgFondo = "";
		String msgIdiomas = "";
		String msgSugerencias = "";
		try {
			msgCabeceraMensaje = Q70GestorMensajesi18n.getSingleton().getMessage("s12Logotipos", "solicitudLogotipo.cabeceraMail", lReport.getIdioma().getIdIdioma());
			msgEntidad = Q70GestorMensajesi18n.getSingleton().getMessage("s12Logotipos", "solicitudLogotipo.entidad", lReport.getIdioma().getIdIdioma());
			msgResponsable = Q70GestorMensajesi18n.getSingleton().getMessage("s12Logotipos", "solicitudLogotipo.responsable", lReport.getIdioma().getIdIdioma());
			msgTelefono = Q70GestorMensajesi18n.getSingleton().getMessage("s12Logotipos", "solicitudLogotipo.telefono", lReport.getIdioma().getIdIdioma());
			msgEmail = Q70GestorMensajesi18n.getSingleton().getMessage("s12Logotipos", "solicitudLogotipo.email", lReport.getIdioma().getIdIdioma());
			msgAplicaciones = Q70GestorMensajesi18n.getSingleton().getMessage("s12Logotipos", "solicitudLogotipo.aplicaciones", lReport.getIdioma().getIdIdioma());
			msgTamano = Q70GestorMensajesi18n.getSingleton().getMessage("s12Logotipos", "solicitudLogotipo.tamano", lReport.getIdioma().getIdIdioma());
			msgFondo = Q70GestorMensajesi18n.getSingleton().getMessage("s12Logotipos", "solicitudLogotipo.fondo", lReport.getIdioma().getIdIdioma());
			msgIdiomas = Q70GestorMensajesi18n.getSingleton().getMessage("s12Logotipos", "solicitudLogotipo.idiomas", lReport.getIdioma().getIdIdioma());
			msgSugerencias = Q70GestorMensajesi18n.getSingleton().getMessage("s12Logotipos", "solicitudLogotipo.sugerencias", lReport.getIdioma().getIdIdioma());
		} catch (Q70GestorMensajesException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12LogotiposReportSolver.COMPONENTE, Q70TraceLevel.DEBUG, "S12LogotiposReportSolver::doXMLReport: recogiendo cadenas traducibles");
			}
		}
		/* B82: cabecera */
		xml.append("<item name=\"s12_cabecera_mensaje\"><value>");
		xml.append(msgCabeceraMensaje);
		xml.append("</value></item>");

		/* B82: datos formulario */
		xml.append("<item name=\"s12_entidad_txt\"><value>");
		xml.append(msgEntidad);
		xml.append("</value></item>");
		xml.append("<item name=\"s12_entidad\"><value>");
		xml.append(this.xmlData(lReport.getSolicitud().getEntidad()));
		xml.append("</value></item>");
		xml.append("<item name=\"s12_responsable_txt\"><value>");
		xml.append(msgResponsable);
		xml.append("</value></item>");
		xml.append("<item name=\"s12_responsable\"><value>");
		xml.append(this.xmlData(lReport.getSolicitud().getResponsable()));
		xml.append("</value></item>");
		xml.append("<item name=\"s12_telefono_txt\"><value>");
		xml.append(msgTelefono);
		xml.append("</value></item>");
		xml.append("<item name=\"s12_telefono\"><value>");
		xml.append(this.xmlData(lReport.getSolicitud().getTelefono()));
		xml.append("</value></item>");
		xml.append("<item name=\"s12_email_txt\"><value>");
		xml.append(msgEmail);
		xml.append("</value></item>");
		xml.append("<item name=\"s12_email\"><value>");
		xml.append(this.xmlData(lReport.getSolicitud().getEmail()));
		xml.append("</value></item>");
		xml.append("<item name=\"s12_aplicaciones_txt\"><value>");
		xml.append(msgAplicaciones);
		xml.append("</value></item>");
		xml.append("<item name=\"s12_aplicaciones\"><value>");
		xml.append(this.xmlData(lReport.getSolicitud().getAplicaciones()));
		xml.append("</value></item>");
		xml.append("<item name=\"s12_tamano_txt\"><value>");
		xml.append(msgTamano);
		xml.append("</value></item>");
		xml.append("<item name=\"s12_tamano\"><value>");
		xml.append(this.xmlData(lReport.getSolicitud().getTamano()));
		xml.append("</value></item>");
		xml.append("<item name=\"s12_fondo_txt\"><value>");
		xml.append(msgFondo);
		xml.append("</value></item>");
		xml.append("<item name=\"s12_fondo\"><value>");
		xml.append(this.xmlData(lReport.getSolicitud().getFondo()));
		xml.append("</value></item>");
		xml.append("<item name=\"s12_idiomas_txt\"><value>");
		xml.append(msgIdiomas);
		xml.append("</value></item>");
		xml.append("<item name=\"s12_idiomas\"><value>");
		xml.append(this.xmlData(lReport.getSolicitud().getIdiomas()));
		xml.append("</value></item>");
		xml.append("<item name=\"s12_sugerencias_txt\"><value>");
		xml.append(msgSugerencias);
		xml.append("</value></item>");
		xml.append("<item name=\"s12_sugerencias\"><value>");
		xml.append(this.xmlData(lReport.getSolicitud().getSugerencias()));
		xml.append("</value></item>");

		String piePagina = "";
		String piePagina2 = "";
		try {
			piePagina = Q70GestorMensajesi18n.getSingleton().getMessage("s12Logotipos", "logotipos.piePagina", lReport.getIdioma().getIdIdioma(), null);
			piePagina2 = Q70GestorMensajesi18n.getSingleton().getMessage("s12Logotipos", "logotipos.piePagina2", lReport.getIdioma().getIdIdioma(), null);
			// RequestUtils.message(pageContext, "s41Recursos", Globals.LOCALE_KEY,
			// "localidad.territorioHistorico");
		} catch (Q70GestorMensajesException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12LogotiposReportSolver.COMPONENTE, Q70TraceLevel.DEBUG, "S12EnviarPostalDisplayAction::process12OP:  INICIO");
			}
			// Falta por capturar esta incidencia
		}
		xml.append("<item name=\"s12_piePagina\"><value>");
		xml.append(this.xmlData(piePagina));
		xml.append("</value></item>");

		xml.append("<item name=\"s12_piePagina2\"><value>");
		xml.append(this.xmlData(piePagina2));
		xml.append("</value></item>");

		// Inicio Pie
		xml.append("<item name=\"s12_imagenPie\"><value>pie_pagina.gif</value></item>");

		// Inicio Alt Pie
		xml.append("<item name=\"s12_altPie\"><value/></item>");

		// Fin Datos Generales
		xml.append("</value></item>");

		xml.append("</record>");
		lReport.setReportXML(xml);
	}
}
