/*
 * Created on 16/12/2011
 *
 */
package s12.servlet.actions;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import bilbofrmk.email.BEMailMessage;
import bilbofrmk.email.BEMailSender;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import s12.eventos.dao.S12FormularioEventosDao;
import s12.eventos.valueObjects.S12FormularioEventos;
import s12.util.S12AppConfig;


/**
 * The Class S12ProgramasExperiencialesAction.
 *  
 */
public class S12SubscribirEventoAction extends HttpServlet{


	private static final String COMPONENTE = "EVENTOS";

	/**
	 *
	 */
	private static final long serialVersionUID = 6714146080326216473L;

	/**
	 * do Get.
	 *
	 * @param request the request
	 * @param response the response
	 *
	 * @throws ServletException the servlet exception
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException{
		// TODO Auto-generated method stub
		this.doPost(request, response);
	}

	/**
	 * do Post.
	 *
	 * @param request the request
	 * @param response the response
	 *
	 * @throws ServletException the servlet exception
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response)	throws ServletException{


		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12SubscribirEventoAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12SubscribirEventoAction:: Inicio");
		}



		S12FormularioEventos formularioEventos = new S12FormularioEventos();


		String language = "";
		if (request.getParameter("language")!=null){
			language = (String)request.getParameter("language");
		}

		String pageForward = "";
		// cssIncluded (variable para saber si estamos en local)
		if(!S12AppConfig.getInstance().getValue("cssIncluded").equals("OK")){
			pageForward = "/x65-16970/" + language + "/";
		}else{
			pageForward = Q70ListenerUtils.getApplicationProperty("URL_PORTAL") + "/x65-16970/" + language + "/";
		}

		try{

			//recuperamos los valores de la request
			String nombre = "";
			if (request.getParameter("nombre")!=null){
				nombre = (String)request.getParameter("nombre");
			}

			String empresa = "";
			if (request.getParameter("empresa")!=null){
				empresa = (String)request.getParameter("empresa");
			}

			String cargo = "";
			if (request.getParameter("cargo")!=null){
				cargo = (String)request.getParameter("cargo");
			}

			long sector = 0;
			if (request.getParameter("sector")!=null){
				sector = Long.parseLong(request.getParameter("sector"));
			}

			String direccion = "";
			if (request.getParameter("direccion")!=null){
				direccion = (String)request.getParameter("direccion");
			}

			String codigoPostal = "";
			if (request.getParameter("codigoPostal")!=null){
				codigoPostal = (String)request.getParameter("codigoPostal");
			}

			String localidad = "";
			if (request.getParameter("localidad")!=null){
				localidad = (String)request.getParameter("localidad");
			}

			String email = "";
			if (request.getParameter("email")!=null){
				email = (String)request.getParameter("email");
			}

			formularioEventos.setNombre(nombre);
			formularioEventos.setEmpresa(empresa);
			formularioEventos.setCargo(cargo);
			formularioEventos.setSector(sector);
			formularioEventos.setDireccion(direccion);
			formularioEventos.setCodigoPostal(codigoPostal);
			formularioEventos.setLocalidad(localidad);
			formularioEventos.setEmail(email);
			formularioEventos.setCodigoIdioma(language);

			S12FormularioEventosDao daoEventos = new S12FormularioEventosDao();

			//insertamos en BBDD
			daoEventos.insertFormulario(formularioEventos);


			//configuramos el envio de email
			String emailServer = Q70ListenerUtils.getApplicationProperty("email.smtp.server");

	    if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12SubscribirEventoAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12SubscribirEventoAction: Obtenidos el emailServer: "+emailServer);
			}

	    String notDeliveryAddress = Q70ListenerUtils.getApplicationProperty("mailbox.notdelivery.gaurkotu");

	    if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12SubscribirEventoAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12SubscribirEventoAction: Obtenidos el notDeliveryAddress: "+notDeliveryAddress);
			}

	    BEMailMessage eMailMessage = new BEMailMessage();
	    BEMailSender sendMessage = new BEMailSender();

	    if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12SubscribirEventoAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12SubscribirEventoAction: email.from: " + Q70ListenerUtils.getApplicationProperty("email.from.gaurkotu"));
			}

	    eMailMessage.setFrom(Q70ListenerUtils.getApplicationProperty("email.from.eventos"));
	    eMailMessage.setEmailServer(emailServer.toString());
	    eMailMessage.setNotDeliveryAddress(notDeliveryAddress.toString());

	    eMailMessage.addTo(formularioEventos.getEmail());

	    long idTitulo = 1, idMensaje = 2;
	    String tituloTexto = daoEventos.getTextoEvento(idTitulo, language);
	    String mensajeTexto = daoEventos.getTextoEvento(idMensaje, language);
	    eMailMessage.setSubject(tituloTexto);
	    eMailMessage.setMsgBodyText(mensajeTexto);

	    //enviamos el email
	    if(!S12AppConfig.getInstance().getValue("cssIncluded").equals("OK")){
	    	sendMessage.send(eMailMessage);
	    }

	    if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12SubscribirEventoAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12SubscribirEventoAction: Email enviado a: " + formularioEventos.getEmail());
			}

    }catch (Exception e) {
    	if(!S12AppConfig.getInstance().getValue("cssIncluded").equals("OK")){
    		pageForward = "/x65-16971/" + language +"/";
			}else{
				pageForward = Q70ListenerUtils.getApplicationProperty("URL_PORTAL") + "/x65-16971/" + language + "/";
			}

		}



		this.forwardJSP(request,response,pageForward);


	}



	/**
	 * Forward jsp.
	 *
	 * @param request the request
	 * @param response the response
	 * @param page the page
	 *
	 * @throws ServletException the servlet exception
	 */
	public void forwardJSP(HttpServletRequest request, HttpServletResponse response, String page) throws ServletException
	{
		try {

			String redirectURL = page;
	    response.sendRedirect(redirectURL);

			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12SubscribirEventoAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12SubscribirEventoAction:: Fin");
			}
		}
		catch (Exception e) {
			e.printStackTrace();
			throw new ServletException( "Failed to process request", e );
		}

	}




}
